/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.multi;

import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceList;
import ivorius.reccomplex.utils.RCStrings;
import ivorius.reccomplex.world.gen.script.WorldScript;
import ivorius.reccomplex.world.gen.script.WorldScriptRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class TableDataSourceWorldScriptList
extends TableDataSourceList<WorldScript, List<WorldScript>> {
    protected BlockPos realWorldPos;

    public TableDataSourceWorldScriptList(List<WorldScript> list, BlockPos realWorldPos, TableDelegate tableDelegate, TableNavigator navigator) {
        super(list, tableDelegate, navigator);
        this.realWorldPos = realWorldPos;
        this.setUsesPresetActionForAdding(true);
        this.duplicateTitle = TextFormatting.GREEN + "D";
    }

    @Override
    public String getDisplayString(WorldScript script) {
        return RCStrings.abbreviateFormatted(script.getDisplayString(), 24);
    }

    @Override
    public WorldScript newEntry(String actionID) {
        return (WorldScript)this.tryInstantiate(actionID, WorldScriptRegistry.INSTANCE.objectClass(actionID), "Failed instantiating world script: %s");
    }

    @Override
    @Nonnull
    public TableCell entryCell(boolean enabled, WorldScript worldScript) {
        return TableCells.edit(enabled, this.navigator, this.tableDelegate, () -> worldScript.tableDataSource(this.realWorldPos, this.navigator, this.tableDelegate));
    }

    @Override
    public WorldScript copyEntry(WorldScript worldScript) {
        return WorldScriptRegistry.INSTANCE.copy(worldScript);
    }

    @Override
    public List<TableCellButton> getAddActions() {
        return TableCells.addManyWithBase(WorldScriptRegistry.INSTANCE.allIDs(), "reccomplex.worldscript.", this.canEditList());
    }

    @Override
    @Nonnull
    public String title() {
        return "Scripts";
    }
}

