/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.structuregenerator;

import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.TableDataSourceBlockPos;
import ivorius.reccomplex.gui.TableDirections;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.worldscripts.TableDataSourceWorldScript;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.script.WorldScriptStructureGenerator;
import java.util.Arrays;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.ArrayUtils;

public class TableDataSourceWorldScriptStructureGenerator
extends TableDataSourceSegmented {
    protected WorldScriptStructureGenerator script;
    protected TableNavigator tableNavigator;
    protected TableDelegate tableDelegate;

    public TableDataSourceWorldScriptStructureGenerator(WorldScriptStructureGenerator script, TableNavigator tableNavigator, TableDelegate tableDelegate) {
        this.script = script;
        this.tableNavigator = tableNavigator;
        this.tableDelegate = tableDelegate;
        this.addManagedSegment(0, new TableDataSourceWorldScript(script));
        this.addManagedSegment(3, new TableDataSourceBlockPos(script.getStructureShift(), script::setStructureShift, null, null, null, IvTranslations.get("reccomplex.worldscript.strucGen.shift.x"), IvTranslations.get("reccomplex.worldscript.strucGen.shift.y"), IvTranslations.get("reccomplex.worldscript.strucGen.shift.z")));
    }

    private static boolean doAllStructuresExist(Iterable<String> structures) {
        for (String s : structures) {
            if (s.length() == 0 || StructureRegistry.INSTANCE.get(s) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int numberOfSegments() {
        return this.script.isSimpleMode() ? 5 : 5;
    }

    @Override
    public int sizeOfSegment(int segment) {
        if (segment == 1) {
            return 1;
        }
        if (segment == 2) {
            return 1;
        }
        if (segment == 4) {
            return this.script.isSimpleMode() ? 2 : 1;
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 1) {
            TableCellBoolean cell = new TableCellBoolean("simpleMode", this.script.isSimpleMode());
            cell.addPropertyConsumer(val -> {
                this.script.setSimpleMode((boolean)val);
                this.tableDelegate.reloadData();
            });
            return new TitledCell(IvTranslations.get("reccomplex.worldscript.strucGen.mode.simple"), cell);
        }
        if (segment == 2) {
            if (this.script.isSimpleMode()) {
                TableCellString cell = new TableCellString("generators", String.join((CharSequence)",", this.script.getStructureNames()));
                cell.setShowsValidityState(true);
                cell.setValidityState(TableDataSourceWorldScriptStructureGenerator.doAllStructuresExist(this.script.getStructureNames()) ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.SEMI_VALID);
                cell.addPropertyConsumer(val -> {
                    this.script.setStructureNames(Arrays.asList(val.split(",")));
                    cell.setValidityState(TableDataSourceWorldScriptStructureGenerator.doAllStructuresExist(this.script.getStructureNames()) ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.SEMI_VALID);
                });
                return new TitledCell(IvTranslations.get("reccomplex.worldscript.strucGen.simple.generators"), cell).withTitleTooltip(IvTranslations.getLines("reccomplex.worldscript.strucGen.simple.generators.tooltip"));
            }
            TableCellString cell = new TableCellString("listID", this.script.getStructureListID());
            cell.addPropertyConsumer(this.script::setStructureListID);
            return new TitledCell(IvTranslations.get("reccomplex.worldscript.strucGen.mode.list.id"), cell);
        }
        if (segment == 4) {
            if (this.script.isSimpleMode()) {
                if (index == 0) {
                    TableCellEnum<Integer> cell = new TableCellEnum<Integer>("rotation", this.script.getStructureRotation(), new TableCellEnum.Option<Integer>(0, IvTranslations.get("reccomplex.rotation.clockwise.0")), new TableCellEnum.Option<Integer>(1, IvTranslations.get("reccomplex.rotation.clockwise.1")), new TableCellEnum.Option<Integer>(2, IvTranslations.get("reccomplex.rotation.clockwise.2")), new TableCellEnum.Option<Integer>(3, IvTranslations.get("reccomplex.rotation.clockwise.3")), new TableCellEnum.Option<Object>(null, IvTranslations.get("reccomplex.worldscript.strucGen.rotation.random")));
                    cell.addPropertyConsumer(this.script::setStructureRotation);
                    return new TitledCell(IvTranslations.get("reccomplex.rotation"), cell);
                }
                if (index == 1) {
                    TableCellEnum<Boolean> cell = new TableCellEnum<Boolean>("mirror", this.script.getStructureMirror(), new TableCellEnum.Option<Boolean>(false, IvTranslations.get("reccomplex.gui.false")), new TableCellEnum.Option<Boolean>(true, IvTranslations.get("reccomplex.gui.true")), new TableCellEnum.Option<Object>(null, IvTranslations.get("reccomplex.worldscript.strucGen.mirror.random")));
                    cell.addPropertyConsumer(this.script::setStructureMirror);
                    return new TitledCell(IvTranslations.get("reccomplex.mirror"), cell);
                }
            } else {
                TableCellEnum<EnumFacing> cell = new TableCellEnum<EnumFacing>("front", this.script.getFront(), TableDirections.getDirectionOptions((EnumFacing[])ArrayUtils.add((Object[])Directions.HORIZONTAL, null), "random"));
                cell.addPropertyConsumer(this.script::setFront);
                return new TitledCell(IvTranslations.get("reccomplex.worldscript.strucGen.mode.list.front"), cell);
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }
}

