/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.item;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.item.IvItemStacks;
import ivorius.reccomplex.gui.inventorygen.GuiEditItemStack;
import ivorius.reccomplex.gui.inventorygen.TableDataSourceInvGenMultiTag;
import ivorius.reccomplex.item.ItemInventoryGenerationTag;
import ivorius.reccomplex.item.ItemSyncableTags;
import ivorius.reccomplex.world.storage.loot.WeightedItemCollection;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInventoryGenMultiTag
extends ItemInventoryGenerationTag
implements ItemSyncableTags {
    public static TIntList emptySlots(IInventory inv) {
        TIntArrayList list = new TIntArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) != null) continue;
            list.add(i);
        }
        return list;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (worldIn.field_72995_K) {
            this.openGui(playerIn, playerIn.field_71071_by.field_70461_c);
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(EntityPlayer player, int slot) {
        Minecraft.func_71410_x().func_147108_a(new GuiEditItemStack<TableDataSourceInvGenMultiTag>(player, slot, new TableDataSourceInvGenMultiTag()));
    }

    @Override
    public void generateInInventory(WorldServer server, IInventory inventory, Random random, ItemStack stack, int fromSlot) {
        WeightedItemCollection weightedItemCollection = ItemInventoryGenMultiTag.inventoryGenerator(stack);
        inventory.func_70299_a(fromSlot, null);
        if (weightedItemCollection != null) {
            IntegerRange range = this.getGenerationCount(stack);
            int amount = range.getMin() < range.getMax() ? random.nextInt(range.getMax() - range.getMin() + 1) + range.getMin() : 0;
            TIntList emptySlots = ItemInventoryGenMultiTag.emptySlots(inventory);
            for (int i = 0; i < amount; ++i) {
                int slot = emptySlots.isEmpty() ? random.nextInt(inventory.func_70302_i_()) : emptySlots.removeAt(random.nextInt(emptySlots.size()));
                ItemStack generated = weightedItemCollection.getRandomItemStack(server, random);
                if (generated == null) continue;
                inventory.func_70299_a(slot, generated);
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedInformation) {
        super.func_77624_a(stack, player, list, advancedInformation);
        IntegerRange range = this.getGenerationCount(stack);
        list.add(String.format("%d - %d Items", range.getMin(), range.getMax()));
    }

    public IntegerRange getGenerationCount(ItemStack stack) {
        return new IntegerRange(IvItemStacks.getNBT(stack, "itemCountMin", 4), IvItemStacks.getNBT(stack, "itemCountMax", 8));
    }

    public void setGenerationCount(ItemStack stack, IntegerRange range) {
        stack.func_77983_a("itemCountMin", (NBTBase)new NBTTagInt(range.getMin()));
        stack.func_77983_a("itemCountMax", (NBTBase)new NBTTagInt(range.getMax()));
    }

    @Override
    public List<Pair<String, Integer>> getSyncedNBTTags() {
        return Arrays.asList(Pair.of((Object)"itemCountMin", (Object)3), Pair.of((Object)"itemCountMax", (Object)3));
    }
}

