/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.item;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.item.GeneratingItem;
import ivorius.reccomplex.world.storage.loot.InventoryGenerationHandler;
import ivorius.reccomplex.world.storage.loot.WeightedItemCollection;
import ivorius.reccomplex.world.storage.loot.WeightedItemCollectionRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class ItemInventoryGenerationTag
extends Item
implements GeneratingItem {
    public static boolean applyGeneratorToInventory(WorldServer world, BlockPos pos, GeneratingItem generatingItem, ItemStack stack) {
        TileEntity rightClicked = world.func_175625_s(pos);
        if (rightClicked instanceof IInventory) {
            if (!world.field_72995_K) {
                generatingItem.generateInInventory(world, (IInventory)rightClicked, world.field_73012_v, stack, world.field_73012_v.nextInt(((IInventory)rightClicked).func_70302_i_()));
                InventoryGenerationHandler.generateAllTags(world, (IInventory)rightClicked, RecurrentComplex.specialRegistry.itemHidingMode(), world.field_73012_v);
            }
            return true;
        }
        return false;
    }

    public static String inventoryGeneratorKey(ItemStack stack) {
        NBTTagCompound nbttagcompound;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("itemCollectionKey", 8)) {
            return stack.func_77978_p().func_74779_i("itemCollectionKey");
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("display", 10) && (nbttagcompound = stack.func_77978_p().func_74775_l("display")).func_150297_b("Name", 8)) {
            return nbttagcompound.func_74779_i("Name");
        }
        return null;
    }

    public static WeightedItemCollection inventoryGenerator(ItemStack stack) {
        return (WeightedItemCollection)WeightedItemCollectionRegistry.INSTANCE.get(ItemInventoryGenerationTag.inventoryGeneratorKey(stack));
    }

    public static void setItemStackGeneratorKey(ItemStack stack, String generatorKey) {
        stack.func_77983_a("itemCollectionKey", (NBTBase)new NBTTagString(generatorKey));
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            return ItemInventoryGenerationTag.applyGeneratorToInventory((WorldServer)worldIn, pos, this, stack) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        return EnumActionResult.SUCCESS;
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        WeightedItemCollectionRegistry.INSTANCE.ids().stream().sorted().forEach(key -> {
            ItemStack stack = new ItemStack(item);
            ItemInventoryGenerationTag.setItemStackGeneratorKey(stack, key);
            list.add(stack);
        });
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String func_77653_i(ItemStack stack) {
        String key = ItemInventoryGenerationTag.inventoryGeneratorKey(stack);
        return key != null ? key : super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedInformation) {
        WeightedItemCollection generator = ItemInventoryGenerationTag.inventoryGenerator(stack);
        if (generator != null) {
            list.add(generator.getDescriptor());
        } else {
            list.add(IvTranslations.get("inventoryGen.none"));
        }
    }
}

