/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.json.NBTToJson;
import ivorius.reccomplex.world.gen.feature.structure.registry.MCRegistrySpecial;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;

public class ItemStackSerializer
implements JsonSerializer<ItemStack>,
JsonDeserializer<ItemStack> {
    private MCRegistrySpecial registry;
    private DataFixer fixer;

    public ItemStackSerializer(MCRegistrySpecial registry) {
        this.registry = registry;
        this.fixer = DataFixesManager.func_188279_a();
    }

    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", this.registry.itemHidingMode().containedItemID(src).toString());
        jsonObject.addProperty("damage", (Number)src.func_77952_i());
        jsonObject.addProperty("count", (Number)src.field_77994_a);
        if (src.func_77942_o()) {
            jsonObject.add("tag", context.serialize((Object)src.func_77978_p()));
        }
        return jsonObject;
    }

    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        NBTTagCompound compound;
        JsonObject jsonObject = JsonUtils.asJsonObject(json, "ItemStack");
        String id = JsonUtils.getString(jsonObject, "id");
        int damage = JsonUtils.getInt(jsonObject, "damage");
        int count = JsonUtils.getInt(jsonObject, "count");
        ItemStack stack = this.registry.itemHidingMode().constructItemStack(new ResourceLocation(id), count, damage);
        if (jsonObject.has("tag")) {
            compound = (NBTTagCompound)context.deserialize(jsonObject.get("tag"), NBTTagCompound.class);
            stack.func_77982_d(compound);
        } else if (jsonObject.has("tagBase64")) {
            compound = NBTToJson.getNBTFromBase64(JsonUtils.getString(jsonObject, "tagBase64"));
            stack.func_77982_d(compound);
        }
        NBTTagCompound fixed = this.fixItemStack(stack);
        ItemStack loadedFixed = ItemStack.func_77949_a((NBTTagCompound)fixed);
        stack = this.registry.itemHidingMode().constructItemStack(new ResourceLocation(fixed.func_74779_i("id")), loadedFixed.field_77994_a, loadedFixed.func_77960_j());
        if (loadedFixed.func_77942_o()) {
            stack.func_77982_d(loadedFixed.func_77978_p());
        }
        return stack;
    }

    @Nonnull
    protected NBTTagCompound fixItemStack(ItemStack stack) {
        NBTTagCompound postCompound = new NBTTagCompound();
        stack.func_77955_b(postCompound);
        this.fixer.func_188257_a((IFixType)FixTypes.ITEM_INSTANCE, postCompound);
        return postCompound;
    }
}

