/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.random;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ivorius.reccomplex.files.SimpleLeveledRegistry;
import ivorius.reccomplex.random.Person;
import ivorius.reccomplex.random.Place;
import ivorius.reccomplex.utils.tokenizer.SymbolTokenizer;
import ivorius.reccomplex.utils.tokenizer.TokenReplacer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class Poem {
    private static final int TITLE_TRIES = 50;
    public static SimpleLeveledRegistry<Theme> THEME_REGISTRY = new SimpleLeveledRegistry("poem theme");
    private String title;
    private String text;

    public Poem(String title, String text) {
        this.title = title;
        this.text = text;
    }

    public static Poem randomPoem(Random random, Integer maxTitleLength, Person author) {
        Map<String, List<List<TokenReplacer.Token>>> stitchedTheme = Poem.stitchStyledTheme(author);
        PoemContext poemContext = new PoemContext();
        while (poemContext.add(random, poemContext.names, 0.3f, Person.randomHuman(random, random.nextBoolean()).getFirstName())) {
        }
        while (poemContext.add(random, poemContext.places, 0.3f, Place.randomPlace(random).getFullPlaceType())) {
        }
        String title = Poem.randomTitle(random, poemContext, maxTitleLength, stitchedTheme);
        String phrase = Poem.evaluate(random, stitchedTheme.get("text"), poemContext, stitchedTheme);
        return new Poem(title, phrase);
    }

    public static Map<String, List<List<TokenReplacer.Token>>> stitchStyledTheme(Person author) {
        Random styleRandom = new Random(author.hashCode());
        SymbolTokenizer<TokenReplacer.Token> tokenizer = new SymbolTokenizer<TokenReplacer.Token>(new SymbolTokenizer.SimpleCharacterRules(Character.valueOf('\\'), null, new char[0], null), Poem.factory());
        HashMultimap map = HashMultimap.create();
        do {
            Theme theme = (Theme)Poem.getRandomElementFrom(THEME_REGISTRY.allActive().stream().collect(Collectors.toList()), styleRandom);
            float acceptance = styleRandom.nextFloat();
            Multimap<String, List<TokenReplacer.Token>> builtTheme = theme.build((Multimap<String, List<TokenReplacer.Token>>)HashMultimap.create(), tokenizer);
            builtTheme.asMap().values().forEach(v -> v.removeIf(p -> styleRandom.nextFloat() < acceptance && v.size() > 1));
            map.putAll(builtTheme);
        } while (styleRandom.nextBoolean());
        return Theme.build((Multimap<String, List<TokenReplacer.Token>>)map);
    }

    @Nonnull
    protected static String randomTitle(Random random, PoemContext poemContext, Integer maxLength, Map<String, List<List<TokenReplacer.Token>>> built) {
        for (int i = 0; i < 50; ++i) {
            String title = Poem.evaluate(random, built.get("title"), poemContext, built).trim();
            if (maxLength != null && title.length() >= maxLength) continue;
            return title;
        }
        return StringUtils.abbreviate((String)Poem.evaluate(random, built.get("title"), poemContext, built).trim(), (int)maxLength);
    }

    private static String evaluate(Random random, List<List<TokenReplacer.Token>> patterns, PoemContext context, Map<String, List<List<TokenReplacer.Token>>> theme) {
        return TokenReplacer.evaluate(random, Poem.getRandomElementFrom(patterns, random), context, theme);
    }

    private static <O> O getRandomElementFrom(List<O> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }

    @Nonnull
    protected static TokenReplacer.ReplaceFactory factory() {
        return new TokenReplacer.ReplaceFactory<PoemContext>(){

            @Override
            @Nonnull
            protected TokenReplacer.Exploder<PoemContext> exploder(String tag, List<String> params) {
                switch (tag) {
                    case "br": {
                        return TokenReplacer.Exploder.string((token, theme, context, random) -> "\n");
                    }
                    case "place": {
                        return TokenReplacer.Exploder.string((token, theme, context, random) -> (String)Poem.getRandomElementFrom(context.places, random));
                    }
                    case "name": {
                        return TokenReplacer.Exploder.string((token, theme, context, random) -> (String)Poem.getRandomElementFrom(context.names, random));
                    }
                    case "number": {
                        return TokenReplacer.Exploder.string(this.numEvaluator(Integer.valueOf(TokenReplacer.Theme.parameter(params, 0, "2")), Integer.valueOf(TokenReplacer.Theme.parameter(params, 1, "10")), Integer.valueOf(TokenReplacer.Theme.parameter(params, 2, "1"))));
                    }
                }
                return (token, theme, context, random) -> {
                    List list = (List)theme.get(tag);
                    return list == null || list.isEmpty() ? Collections.singletonList(new TokenReplacer.StringToken(0, 0, "EMPTY")) : (List<TokenReplacer.StringToken>)Poem.getRandomElementFrom(list, random);
                };
            }

            private TokenReplacer.Exploder.StringExploder<PoemContext> numEvaluator(int min, int max, int mul) {
                return (token, theme, context, random) -> String.valueOf((random.nextInt(max - min + 1) + min) * mul);
            }
        };
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public static class Theme
    extends TokenReplacer.Theme {
        public static Theme fromFile(String fileContents) {
            Theme theme = new Theme();
            theme.read(fileContents);
            return theme;
        }

        @Override
        protected TokenReplacer.Theme getOther(String include) {
            return THEME_REGISTRY.get(include);
        }
    }

    public static class PoemContext {
        public List<String> names = new ArrayList<String>();
        public List<String> places = new ArrayList<String>();

        public boolean add(Random random, List<String> list, float continueChance, String value) {
            list.add(value);
            return random.nextFloat() < continueChance;
        }
    }
}

