/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class FMLRemapper {
    protected final Map<ResourceLocation, ResourceLocation> blockRemaps = Maps.newHashMap();
    protected final Map<ResourceLocation, ResourceLocation> itemRemaps = Maps.newHashMap();
    protected final Map<ResourceLocation, ResourceLocation> tileEntityRemaps = Maps.newHashMap();

    public Map<ResourceLocation, ResourceLocation> getBlockRemaps() {
        return Collections.unmodifiableMap(this.blockRemaps);
    }

    public Map<ResourceLocation, ResourceLocation> getItemRemaps() {
        return Collections.unmodifiableMap(this.itemRemaps);
    }

    public Map<ResourceLocation, ResourceLocation> getTileEntityRemaps() {
        return Collections.unmodifiableMap(this.tileEntityRemaps);
    }

    public void registerLegacyBlockIDs(ResourceLocation blockID, boolean inferItem, ResourceLocation ... oldIDs) {
        for (ResourceLocation oldID : oldIDs) {
            this.blockRemaps.put(oldID, blockID);
            if (!inferItem) continue;
            this.itemRemaps.put(oldID, blockID);
        }
    }

    public void registerLegacyItemIDs(ResourceLocation itemID, ResourceLocation ... oldIDs) {
        for (ResourceLocation oldID : oldIDs) {
            this.itemRemaps.put(oldID, itemID);
        }
    }

    public void registerLegacyTileEntityIDs(ResourceLocation tileEntityID, ResourceLocation ... oldIDs) {
        for (ResourceLocation oldID : oldIDs) {
            this.tileEntityRemaps.put(oldID, tileEntityID);
        }
    }

    public ResourceLocation mapBlock(ResourceLocation id) {
        ResourceLocation remap = this.blockRemaps.get(id);
        return remap != null ? remap : id;
    }

    @Nullable
    public ResourceLocation remapBlock(ResourceLocation id) {
        return this.blockRemaps.get(id);
    }

    public ResourceLocation mapItem(ResourceLocation id) {
        ResourceLocation remap = this.itemRemaps.get(id);
        return remap != null ? remap : id;
    }

    @Nullable
    public ResourceLocation remapItem(ResourceLocation id) {
        return this.itemRemaps.get(id);
    }

    public ResourceLocation mapTileEntity(ResourceLocation id) {
        ResourceLocation remap = this.tileEntityRemaps.get(id);
        return remap != null ? remap : id;
    }

    @Nullable
    public ResourceLocation remapTileEntity(ResourceLocation id) {
        return this.tileEntityRemaps.get(id);
    }
}

