/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;

public class RCStrings {
    private static MutablePair<Integer, Integer> abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return MutablePair.of((Object)0, (Object)str.length());
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return MutablePair.of((Object)0, (Object)(maxWidth - 3));
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + maxWidth - 3 < str.length()) {
            MutablePair<Integer, Integer> abbreviated = RCStrings.abbreviate(str.substring(offset), 0, maxWidth - 3);
            return MutablePair.of((Object)offset, (Object)(offset + (Integer)abbreviated.getRight()));
        }
        return MutablePair.of((Object)(str.length() - (maxWidth - 3)), (Object)str.length());
    }

    @Nonnull
    public static String abbreviateFormatted(String str, int offset, int maxWidth) {
        MutablePair<Integer, Integer> abbreviate = RCStrings.abbreviate(str, offset, maxWidth);
        String abbreviated = str.substring((Integer)abbreviate.getLeft(), (Integer)abbreviate.getRight());
        if ((Integer)abbreviate.getLeft() > 0) {
            String prevFormat = "";
            if (str.length() > (Integer)abbreviate.getLeft()) {
                for (int i = (Integer)abbreviate.getLeft() - 1; i >= 0; --i) {
                    char fst = str.charAt(i);
                    char scd = str.charAt(i + 1);
                    if (fst != '\u00a7' || scd == '\u00a7') continue;
                    prevFormat = "" + fst + scd + prevFormat;
                }
            }
            if (str.charAt((Integer)abbreviate.getLeft() - 1) == '\u00a7') {
                abbreviated = abbreviated.substring(1);
            }
            abbreviated = "..." + prevFormat + abbreviated;
        }
        if ((Integer)abbreviate.getRight() < str.length()) {
            if (str.charAt((Integer)abbreviate.getRight() - 1) == '\u00a7') {
                abbreviated = abbreviated.substring(0, abbreviated.length() - 1);
            }
            abbreviated = abbreviated + TextFormatting.RESET + "...";
        }
        return abbreviated;
    }

    public static String abbreviateFormatted(String str, int maxWidth) {
        return RCStrings.abbreviateFormatted(str, 0, maxWidth);
    }

    public static Long seed(String seed) {
        if (seed == null || StringUtils.isEmpty((CharSequence)seed)) {
            return null;
        }
        try {
            long j = Long.parseLong(seed);
            if (j != 0L) {
                return j;
            }
        }
        catch (NumberFormatException var7) {
            return seed.hashCode();
        }
        return null;
    }
}

