/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.algebra;

import ivorius.reccomplex.utils.algebra.Algebra;
import java.util.function.Function;
import java.util.stream.Stream;

public class ExpressionAlgebra {
    public static <T> Algebra.Operator<Object> fromAlgebra(Algebra.Operator<T> operator, final Class<T> clazz) {
        return new Algebra.Operator<Object>(operator.precedence, operator.hasLeftArgument, operator.hasRightArgument, operator.symbols){

            @Override
            public <V> Object evaluate(Function<V, Object> variableEvaluator, Algebra.Expression<Object, V>[] expressions) {
                Object[] result = Stream.of(expressions).map(e -> e.evaluate(variableEvaluator)).toArray();
                if (!Stream.of(result).allMatch(r -> clazz.isAssignableFrom(result.getClass()))) {
                    throw new IllegalArgumentException();
                }
                return result;
            }
        };
    }
}

