/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.presets;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import ivorius.reccomplex.files.SimpleLeveledRegistry;
import ivorius.reccomplex.files.loading.FileLoaderRegistryString;
import ivorius.reccomplex.files.saving.FileSaverString;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class PresetRegistry<T> {
    protected final SimpleLeveledRegistry<Preset<T>> registry;
    protected Gson gson;
    @Nullable
    protected String defaultID;
    protected String fileSuffix;

    public PresetRegistry(String fileSuffix, String description) {
        this.fileSuffix = fileSuffix;
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        this.registerGson(builder);
        this.gson = builder.create();
        this.registry = new SimpleLeveledRegistry(description);
    }

    @Nonnull
    public static <T> Preset<T> fullPreset(@Nonnull String id, @Nonnull T t, @Nullable Metadata metadata) {
        return new Preset<T>(t, metadata != null ? metadata : new Metadata(id, new String[0]));
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public SimpleLeveledRegistry<Preset<T>> getRegistry() {
        return this.registry;
    }

    public void setDefault(@Nonnull String type) {
        this.defaultID = type;
    }

    @Nullable
    public String defaultID() {
        return this.defaultID;
    }

    @Nonnull
    public Optional<T> preset(String id) {
        return this.originalPreset(id).map(this::copy);
    }

    @Nonnull
    public Optional<T> originalPreset(String id) {
        return Optional.ofNullable(this.registry.get(id)).map(p -> p.t);
    }

    public Metadata copy(Metadata meta) {
        return (Metadata)this.gson.fromJson(this.gson.toJsonTree((Object)meta), Metadata.class);
    }

    public T copy(T t) {
        return (T)this.gson.fromJson(this.gson.toJsonTree(t), this.getType());
    }

    @Nonnull
    public Optional<Preset<T>> fullPreset(String id) {
        return this.metadata(id).flatMap(m -> this.preset(id).map(p -> new Preset<Object>(p, (Metadata)m)));
    }

    @Nonnull
    public Optional<String> title(String id) {
        return this.metadata(id).map(m -> m.title);
    }

    @Nonnull
    public Optional<List<String>> description(String id) {
        return this.metadata(id).map(d -> d.description).map(Lists::newArrayList);
    }

    @Nonnull
    public Optional<Metadata> metadata(String id) {
        return Optional.ofNullable(this.registry.get(id)).map(p -> this.copy(p.metadata));
    }

    public Collection<String> allIDs() {
        return this.registry.ids();
    }

    public boolean has(String id) {
        return this.registry.has(id);
    }

    protected abstract void registerGson(GsonBuilder var1);

    protected abstract Type getType();

    public FileLoaderRegistryString loader() {
        return new FileLoaderRegistryString<Preset>(this.fileSuffix, this.registry, this::read);
    }

    public FileSaverString<Preset<T>> saver(String id) {
        return new FileSaverString<Preset<T>>(id, this.fileSuffix, this.registry, this::write);
    }

    public Preset<T> read(String file) throws Exception {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(file).getAsJsonObject();
        Object t = this.gson.fromJson(jsonObject.get("data"), this.getType());
        Metadata metadata = (Metadata)this.gson.fromJson(jsonObject.get("metadata"), Metadata.class);
        if (t == null || metadata == null) {
            throw new ParseException("Error parsing preset", 0);
        }
        return new Preset<Object>(t, metadata);
    }

    public String write(Preset p) throws Exception {
        JsonObject object = new JsonObject();
        object.add("data", this.gson.toJsonTree(p.t));
        object.add("metadata", this.gson.toJsonTree((Object)p.metadata));
        return this.gson.toJson((JsonElement)object);
    }

    protected static class Preset<T> {
        public T t;
        public Metadata metadata;

        public Preset(T t, Metadata metadata) {
            this.t = t;
            this.metadata = metadata;
        }
    }

    public static class Metadata {
        public String title = "";
        public String[] description;

        public Metadata(String title, String[] description) {
            this.title = title;
            this.description = description;
        }

        public Metadata(String title, String description) {
            this.title = title;
            this.description = new String[]{description};
        }
    }
}

