/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature;

import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.events.RCEventBus;
import ivorius.reccomplex.events.StructureGenerationEvent;
import ivorius.reccomplex.events.StructureGenerationEventLite;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.utils.RCAxisAlignedTransform;
import ivorius.reccomplex.world.gen.feature.WorldStructureGenerationData;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.Placer;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.VariableDomain;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.StructurePlaceContext;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class StructureGenerator<S extends NBTStorable> {
    public static final int MIN_DIST_TO_LIMIT = 1;
    public static final long PLACE_SEED = 1923419028309182309L;
    public static final long PREPARE_SEED = 2482039482903842269L;
    public static final long GENERATE_SEED = 2309842093742837432L;
    public static final long TRANSFORM_SEED = 1283901823092812394L;
    @Nullable
    private WorldServer world;
    @Nullable
    private Structure<S> structure;
    @Nullable
    private String structureID;
    @Nullable
    private BlockPos lowerCoord;
    @Nullable
    private BlockSurfacePos surfacePos;
    @Nullable
    private Placer placer;
    private boolean fromCenter;
    @Nullable
    private Environment environment;
    @Nullable
    private Long seed;
    @Nullable
    private AxisAlignedTransform2D transform;
    @Nullable
    private StructureBoundingBox boundingBox;
    @Nullable
    private StructureBoundingBox generationBB;
    @Nullable
    private Predicate<Vec3i> generationPredicate;
    private String generationInfoID;
    private GenerationType generationType;
    private int generationLayer = 0;
    private boolean generateAsSource = false;
    private StructureSpawnContext.GenerateMaturity generateMaturity = StructureSpawnContext.GenerateMaturity.FIRST;
    @Nullable
    private S instanceData;
    @Nullable
    private NBTBase instanceDataNBT;
    private boolean allowOverlaps = false;
    private boolean memorize = true;
    private boolean partially;

    public StructureGenerator(Structure<S> structure) {
        this.structure(structure);
    }

    public StructureGenerator() {
    }

    @Nonnull
    public static Placer worldHeightPlacer() {
        return (context, blockCollection) -> context.environment.world.func_175645_m(new BlockPos(context.boundingBox.func_180717_f())).func_177956_o();
    }

    public static String name(String structureName) {
        return structureName != null ? structureName : "Unknown";
    }

    public Optional<WorldStructureGenerationData.StructureEntry> generate() {
        Optional<S> optionalInstanceData = this.instanceData();
        if (!optionalInstanceData.isPresent()) {
            return this.failGenerate("failed to place");
        }
        NBTStorable instanceData = (NBTStorable)optionalInstanceData.get();
        StructureSpawnContext spawn = this.spawn().get();
        Structure<NBTStorable> structure = this.structure();
        String structureID = this.structureID();
        boolean firstTime = spawn.generateMaturity.isFirstTime();
        WorldServer world = spawn.environment.world;
        StructureBoundingBox boundingBox = spawn.boundingBox;
        if (this.maturity().isSuggest() && (boundingBox.field_78895_b < 1 || boundingBox.field_78894_e > world.func_72800_K() - 1 - 1 || RCConfig.avoidOverlappingGeneration && !this.allowOverlaps && !WorldStructureGenerationData.get((World)world).entriesAt(boundingBox).noneMatch(WorldStructureGenerationData.Entry::blocking) || RCEventBus.INSTANCE.post((Event)new StructureGenerationEvent.Suggest(structure, spawn)) || structureID != null && MinecraftForge.EVENT_BUS.post((Event)new StructureGenerationEventLite.Suggest((World)world, structureID, boundingBox, spawn.generationLayer, firstTime)))) {
            return this.failGenerate("unknown reason");
        }
        if (firstTime) {
            RCEventBus.INSTANCE.post((Event)new StructureGenerationEvent.Pre(structure, spawn));
            if (structureID != null) {
                MinecraftForge.EVENT_BUS.post((Event)new StructureGenerationEventLite.Pre((World)world, structureID, boundingBox, spawn.generationLayer, firstTime));
            }
        }
        try {
            structure.generate(spawn, instanceData, RCConfig.getUniversalTransformer());
        }
        catch (Exception e) {
            RecurrentComplex.logger.error("Error on structure generation", (Throwable)e);
            return this.failGenerate("exception on generation");
        }
        if (!firstTime) {
            return Optional.empty();
        }
        RecurrentComplex.logger.trace(String.format("Generated structure '%s' in %s (%d)", StructureGenerator.name(structureID), boundingBox, world.field_73011_w.getDimension()));
        RCEventBus.INSTANCE.post((Event)new StructureGenerationEvent.Post(structure, spawn));
        if (structureID != null) {
            MinecraftForge.EVENT_BUS.post((Event)new StructureGenerationEventLite.Post((World)world, structureID, boundingBox, spawn.generationLayer, firstTime));
        }
        if (structureID == null || !this.memorize) {
            return Optional.empty();
        }
        String generationInfoID = this.generationType != null ? this.generationType.id() : null;
        WorldStructureGenerationData.StructureEntry structureEntry = WorldStructureGenerationData.StructureEntry.complete(structureID, generationInfoID, boundingBox, spawn.transform, !this.partially);
        structureEntry.blocking = structure.isBlocking();
        structureEntry.firstTime = false;
        structureEntry.seed = this.seed();
        try {
            structureEntry.instanceData = instanceData.writeToNBT();
        }
        catch (Exception e) {
            RecurrentComplex.logger.error(String.format("Error saving instance data for structure %s in %s", structure, boundingBox), (Throwable)e);
        }
        Collection existingChunks = WorldStructureGenerationData.get((World)world).addEntry(structureEntry).stream().collect(Collectors.toList());
        if (this.partially) {
            this.maturity(StructureSpawnContext.GenerateMaturity.COMPLEMENT);
            StructureBoundingBox oldBB = this.generationBB;
            for (ChunkPos existingChunk : existingChunks) {
                this.generationBB(Structures.chunkBoundingBox(existingChunk, true));
                if (oldBB.func_78884_a(this.generationBB)) continue;
                structure.generate(this.spawn().get(), instanceData, RCConfig.getUniversalTransformer());
            }
            this.generationBB(oldBB);
        }
        return Optional.of(structureEntry);
    }

    @Nullable
    protected Optional<WorldStructureGenerationData.StructureEntry> failGenerate(String reason) {
        if (RCConfig.logFailingStructure(this.structure)) {
            RecurrentComplex.logger.trace(String.format("%s canceled generation at %s (%d) (%s)", this.structure, this.lowerCoord().orElse(null), this.world.field_73011_w.getDimension(), reason));
        }
        return null;
    }

    public StructureGenerator<S> asChild(StructureSpawnContext context, VariableDomain variableDomain) {
        return this.environment(context.environment.copy(variableDomain)).seed(context.random.nextLong()).transform(context.transform).generationBB(context.generationBB).generationPredicate(context.generationPredicate).generationLayer(context.generationLayer + 1).asSource(context.generateAsSource).maturity(context.generateMaturity.isFirstTime() ? StructureSpawnContext.GenerateMaturity.FIRST : StructureSpawnContext.GenerateMaturity.COMPLEMENT);
    }

    public StructureGenerator<S> asChild(StructureSpawnContext context) {
        return this.asChild(context, null);
    }

    public StructureGenerator<S> world(@Nonnull WorldServer world) {
        this.world = world;
        return this;
    }

    @Nonnull
    public WorldServer world() {
        WorldServer world;
        Object object = this.world != null ? this.world : (world = this.environment != null ? this.environment.world : null);
        if (world == null) {
            throw new IllegalStateException("No world!");
        }
        return world;
    }

    public long seed() {
        return this.seed != null ? this.seed : (this.seed = Long.valueOf(this.world().field_73012_v.nextLong()));
    }

    public StructureGenerator<S> structure(@Nonnull Structure<S> structure) {
        this.structure = structure;
        return this;
    }

    public StructureGenerator<S> structureID(@Nonnull String structureID) {
        this.structureID = structureID;
        return this;
    }

    @Nonnull
    public Structure<S> structure() {
        Structure structure;
        Structure structure2 = this.structure != null ? this.structure : (structure = this.structureID != null ? (Structure)StructureRegistry.INSTANCE.get(this.structureID) : null);
        if (structure == null) {
            throw new IllegalStateException();
        }
        return structure;
    }

    @Nullable
    public String structureID() {
        return this.structureID != null ? this.structureID : (this.structure != null ? StructureRegistry.INSTANCE.id(this.structure) : null);
    }

    public StructureGenerator<S> lowerCoord(@Nonnull BlockPos lowerCoord) {
        this.lowerCoord = lowerCoord;
        return this;
    }

    @Nonnull
    public Optional<BlockPos> lowerCoord() {
        if (this.lowerCoord != null) {
            return Optional.of(this.lowerCoord);
        }
        return this.boundingBox().map(StructureBoundingBoxes::min);
    }

    public StructureGenerator<S> randomPosition(@Nonnull BlockSurfacePos surfacePos, @Nullable Placer placer) {
        this.surfacePos = surfacePos;
        this.placer = placer != null ? placer : StructureGenerator.worldHeightPlacer();
        return this;
    }

    public StructureGenerator<S> fromCenter(boolean fromCenter) {
        this.fromCenter = fromCenter;
        return this;
    }

    public StructureGenerator<S> environment(@Nonnull Environment environment) {
        this.environment = environment;
        return this;
    }

    @Nonnull
    public Environment environment() {
        return this.environment != null ? this.environment : Environment.inNature(this.world(), this.surfaceBoundingBox(), this.generationType != null ? this.generationType : (this.generationInfoID != null ? this.structure().generationType(this.generationInfoID) : null));
    }

    public StructureGenerator<S> seed(Long seed) {
        this.seed = seed;
        return this;
    }

    public StructureGenerator<S> transform(AxisAlignedTransform2D transform) {
        this.transform = transform;
        return this;
    }

    @Nonnull
    public AxisAlignedTransform2D transform() {
        AxisAlignedTransform2D transform;
        if (this.transform != null) {
            return this.transform;
        }
        Structure<S> structure = this.structure();
        Random random = new Random(this.seed() ^ 0x11D155E7DBEC6A6AL);
        this.transform = transform = AxisAlignedTransform2D.from(structure.isRotatable() ? random.nextInt(4) : 0, structure.isMirrorable() && random.nextBoolean());
        return this.transform;
    }

    public StructureGenerator<S> boundingBox(@Nonnull StructureBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    public Optional<StructureBoundingBox> boundingBox() {
        return this.boundingBox(true);
    }

    @Nonnull
    public StructureBoundingBox surfaceBoundingBox() {
        return this.boundingBox(false).get();
    }

    @Nonnull
    protected Optional<StructureBoundingBox> boundingBox(boolean placed) {
        StructureBoundingBox boundingBox;
        StructureBoundingBox structureBoundingBox = boundingBox = this.boundingBox != null ? this.boundingBox : null;
        if (boundingBox == null) {
            int[] size = this.structureSize();
            if (this.lowerCoord != null) {
                boundingBox = Structures.boundingBox(this.fromCenter ? this.lowerCoord.func_177973_b(new Vec3i(size[0] / 2, 0, size[2] / 2)) : this.lowerCoord, size);
            } else if (this.surfacePos != null && this.placer != null) {
                boundingBox = Structures.boundingBox((this.fromCenter ? this.surfacePos.subtract(size[0] / 2, size[2] / 2) : this.surfacePos).blockPos(0), size);
                if (placed) {
                    int y = this.placer.place(this.place(), this.structure().blockCollection());
                    if (y < 0) {
                        return Optional.empty();
                    }
                    boundingBox.field_78895_b += y;
                    boundingBox.field_78894_e += y;
                }
            } else {
                throw new IllegalStateException("No place!");
            }
        }
        if (placed) {
            this.boundingBox = boundingBox;
        }
        return Optional.of(boundingBox);
    }

    public int[] structureSize() {
        return RCAxisAlignedTransform.applySize(this.transform(), this.structure().size());
    }

    @Nullable
    public StructureBoundingBox generationBB() {
        return this.generationBB;
    }

    public StructureGenerator<S> generationBB(@Nullable StructureBoundingBox generationBB) {
        this.generationBB = generationBB;
        return this;
    }

    @Nullable
    public Predicate<Vec3i> generationPredicate() {
        return this.generationPredicate;
    }

    public StructureGenerator<S> generationPredicate(@Nullable Predicate<Vec3i> generationPredicate) {
        this.generationPredicate = generationPredicate;
        return this;
    }

    public StructureGenerator<S> generationInfo(@Nullable GenerationType generationType) {
        this.generationType = generationType;
        return this;
    }

    public StructureGenerator<S> generationInfo(@Nullable String generationInfo) {
        this.generationInfoID = generationInfo;
        return this;
    }

    public StructureGenerator<S> generationLayer(int generationLayer) {
        this.generationLayer = generationLayer;
        return this;
    }

    public StructureGenerator<S> asSource(boolean generateAsSource) {
        this.generateAsSource = generateAsSource;
        return this;
    }

    public StructureGenerator<S> maturity(StructureSpawnContext.GenerateMaturity generateMaturity) {
        this.generateMaturity = generateMaturity;
        return this;
    }

    public StructureSpawnContext.GenerateMaturity maturity() {
        return this.generateMaturity;
    }

    public StructureGenerator<S> instanceData(S s) {
        this.instanceData = s;
        return this;
    }

    public StructureGenerator<S> instanceData(NBTBase nbt) {
        this.instanceDataNBT = nbt;
        return this;
    }

    @Nonnull
    public Optional<S> instanceData() {
        return this.instanceData != null ? Optional.of(this.instanceData) : (this.instanceDataNBT != null ? this.load().map(load -> this.structure().loadInstanceData((StructureLoadContext)load, this.instanceDataNBT, RCConfig.getUniversalTransformer())) : this.prepare().flatMap(prepare -> {
            try {
                return Optional.ofNullable(this.structure().prepareInstanceData((StructurePrepareContext)prepare, RCConfig.getUniversalTransformer()));
            }
            catch (Exception e) {
                if (e instanceof ExpectedException && ((ExpectedException)((Object)e)).isExpected()) {
                    RecurrentComplex.logger.error(String.format("Error preparing structure: %s, Cause: %s", this.structure(), e.getMessage()));
                } else {
                    RecurrentComplex.logger.error("Error preparing structure: " + this.structure(), (Throwable)e);
                }
                return Optional.empty();
            }
        }));
    }

    public StructureGenerator<S> memorize(boolean memorize) {
        this.memorize = memorize;
        return this;
    }

    public StructureGenerator<S> partially(boolean partially, ChunkPos pos) {
        this.partially = partially;
        this.generationBB(partially ? Structures.chunkBoundingBox(pos, true) : null);
        return this;
    }

    public StructureGenerator<S> allowOverlaps(boolean allowOverlaps) {
        this.allowOverlaps = allowOverlaps;
        return this;
    }

    @Nonnull
    public StructurePlaceContext place() {
        return new StructurePlaceContext(new Random(this.seed() ^ 0x1AB15B6A60988765L), this.environment(), this.transform(), this.surfaceBoundingBox());
    }

    @Nonnull
    public Optional<StructurePrepareContext> prepare() {
        return this.boundingBox().map(bb -> new StructurePrepareContext(this.transform(), (StructureBoundingBox)bb, this.generateAsSource, this.environment(), new Random(this.seed() ^ 0x2271F9C260FA4DDDL), this.generateMaturity));
    }

    @Nonnull
    public Optional<StructureLoadContext> load() {
        return this.boundingBox().map(bb -> new StructureLoadContext(this.transform(), (StructureBoundingBox)bb, this.generateAsSource));
    }

    @Nonnull
    public Optional<StructureSpawnContext> spawn() {
        return this.boundingBox().map(bb -> new StructureSpawnContext(this.environment(), new Random(this.seed() ^ 0x200E35256CC94EB8L), this.transform(), (StructureBoundingBox)bb, this.generationBB, this.generationPredicate, this.generationLayer, this.generateAsSource, this.generateMaturity));
    }

    public static interface ExpectedException {
        public boolean isExpected();
    }
}

