/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure;

import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class Structures {
    public static StructureBoundingBox boundingBox(@Nonnull BlockPos coord, @Nonnull int[] size) {
        return new StructureBoundingBox((Vec3i)coord, (Vec3i)coord.func_177982_a(size[0] - 1, size[1] - 1, size[2] - 1));
    }

    public static StructureBoundingBox chunkBoundingBox(ChunkPos chunkPos, boolean decorate) {
        int shift = decorate ? 8 : 0;
        int minZ = (chunkPos.field_77275_b << 4) + shift;
        int minX = (chunkPos.field_77276_a << 4) + shift;
        return new StructureBoundingBox(minX, minZ, minX + 15, minZ + 15);
    }

    public static StructureBoundingBox intersection(StructureBoundingBox bb1, StructureBoundingBox bb2) {
        int x1 = Math.max(bb1.field_78897_a, bb2.field_78897_a);
        int y1 = Math.max(bb1.field_78895_b, bb2.field_78895_b);
        int z1 = Math.max(bb1.field_78896_c, bb2.field_78896_c);
        int x2 = Math.min(bb1.field_78893_d, bb2.field_78893_d);
        int y2 = Math.min(bb1.field_78894_e, bb2.field_78894_e);
        int z2 = Math.min(bb1.field_78892_f, bb2.field_78892_f);
        return new StructureBoundingBox(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2));
    }

    public static GuiValidityStateIndicator.State isSimpleIDState(String id) {
        return Structures.isSimpleID(id) ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.INVALID;
    }

    public static boolean isSimpleID(String id) {
        return !id.trim().isEmpty() && id.chars().allMatch(Character::isJavaIdentifierPart);
    }
}

