/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.generation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.world.chunk.Chunks;
import ivorius.reccomplex.client.rendering.MazeVisualizationContext;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceStaticGeneration;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.DimensionExpression;
import ivorius.reccomplex.utils.presets.PresettedObject;
import ivorius.reccomplex.utils.presets.PresettedObjects;
import ivorius.reccomplex.world.gen.feature.structure.Placer;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.GenericPlacer;
import ivorius.reccomplex.world.gen.feature.structure.generic.presets.GenericPlacerPresets;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class StaticGeneration
extends GenerationType {
    private static Gson gson = StaticGeneration.createGson();
    public final PresettedObject<GenericPlacer> placer = new PresettedObject<GenericPlacer>(GenericPlacerPresets.instance(), null);
    public DimensionExpression dimensionExpression;
    public boolean relativeToSpawn;
    public BlockSurfacePos position;
    @Nullable
    public Pattern pattern;

    public StaticGeneration() {
        this(null, ExpressionCache.of(new DimensionExpression(), "0"), true, BlockSurfacePos.ORIGIN, null);
    }

    public StaticGeneration(@Nullable String id, DimensionExpression dimensionExpression, boolean relativeToSpawn, BlockSurfacePos position, Pattern pattern) {
        super(id != null ? id : StaticGeneration.randomID(StaticGeneration.class));
        this.dimensionExpression = dimensionExpression;
        this.relativeToSpawn = relativeToSpawn;
        this.position = position;
        this.pattern = pattern;
        this.placer.setPreset("surface");
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(StaticGeneration.class, (Object)new Serializer());
        builder.registerTypeAdapter(GenericPlacer.class, (Object)new GenericPlacer.Serializer());
        return builder.create();
    }

    public static Gson getGson() {
        return gson;
    }

    public static Stream<Triple<Structure<?>, StaticGeneration, BlockSurfacePos>> structuresAt(StructureRegistry registry, ChunkPos chunkPos, World world, BlockPos spawnPos) {
        Predicate<Pair> predicate = input -> {
            StaticGeneration info = (StaticGeneration)input.getRight();
            return info.dimensionExpression.test(world.field_73011_w) && (info.pattern != null || Chunks.contains(chunkPos, info.getPos(spawnPos)));
        };
        Stream<Pair> statics = registry.getGenerationTypes(StaticGeneration.class).stream().filter(predicate);
        return statics.flatMap(pair -> {
            StaticGeneration info = (StaticGeneration)pair.getRight();
            return info.hasPattern() ? Chunks.repeatIntersections(chunkPos, info.getPos(spawnPos), info.pattern.repeatX, info.pattern.repeatZ).map(pos -> Triple.of((Object)pair.getLeft(), (Object)info, (Object)pos)) : Stream.of(Triple.of((Object)pair.getLeft(), (Object)info, (Object)info.getPos(spawnPos)));
        });
    }

    public BlockSurfacePos getPosition() {
        return this.position;
    }

    public void setPosition(BlockSurfacePos position) {
        this.position = position;
    }

    @Override
    @Nonnull
    public String id() {
        return this.id;
    }

    @Override
    public void setID(@Nonnull String id) {
        this.id = id;
    }

    @Override
    public String displayString() {
        if (this.hasPattern()) {
            return IvTranslations.format("reccomplex.generationInfo.static.summary.pattern", String.valueOf(this.pattern.repeatX), String.valueOf(this.pattern.repeatZ));
        }
        if (this.relativeToSpawn) {
            return IvTranslations.format("reccomplex.generationInfo.static.summary.spawn", String.valueOf(this.position.x), String.valueOf(this.position.z));
        }
        return IvTranslations.format("reccomplex.generationInfo.static.summary.nospawn", String.valueOf(this.position.x), String.valueOf(this.position.z));
    }

    @Override
    @Nullable
    public Placer placer() {
        return this.placer.getContents();
    }

    @Override
    public TableDataSource tableDataSource(MazeVisualizationContext mazeVisualizationContext, TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceStaticGeneration(navigator, delegate, this);
    }

    public BlockSurfacePos getPos(BlockPos spawnPos) {
        return new BlockSurfacePos(this.relativeToSpawn ? spawnPos.func_177958_n() + this.position.x : this.position.x, this.relativeToSpawn ? spawnPos.func_177952_p() + this.position.z : this.position.z);
    }

    public boolean hasPattern() {
        return this.pattern != null;
    }

    public static class Serializer
    implements JsonSerializer<StaticGeneration>,
    JsonDeserializer<StaticGeneration> {
        public StaticGeneration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "vanillaStructureSpawnInfo");
            String id = GenerationType.readID(jsonObject);
            String dimension = JsonUtils.getString(jsonObject, "dimensions", "");
            boolean relativeToSpawn = JsonUtils.getBoolean(jsonObject, "relativeToSpawn", false);
            int positionX = JsonUtils.getInt(jsonObject, "positionX", 0);
            int positionZ = JsonUtils.getInt(jsonObject, "positionZ", 0);
            Pattern pattern = jsonObject.has("pattern") ? (Pattern)gson.fromJson(jsonObject.get("pattern"), Pattern.class) : null;
            StaticGeneration staticGenInfo = new StaticGeneration(id, ExpressionCache.of(new DimensionExpression(), dimension), relativeToSpawn, new BlockSurfacePos(positionX, positionZ), pattern);
            if (!PresettedObjects.read(jsonObject, gson, staticGenInfo.placer, "placerPreset", "placer", new TypeToken<GenericPlacer>(){}.getType()) && jsonObject.has("generationY")) {
                GenericPlacer.Serializer.readLegacyPlacer(staticGenInfo.placer, context, JsonUtils.getJsonObject(jsonObject, "generationY", new JsonObject()));
            }
            return staticGenInfo;
        }

        public JsonElement serialize(StaticGeneration src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.id);
            PresettedObjects.write(jsonObject, gson, src.placer, "placerPreset", "placer");
            jsonObject.addProperty("dimensions", src.dimensionExpression.getExpression());
            jsonObject.addProperty("relativeToSpawn", Boolean.valueOf(src.relativeToSpawn));
            jsonObject.addProperty("positionX", (Number)src.position.x);
            jsonObject.addProperty("positionZ", (Number)src.position.z);
            if (src.pattern != null) {
                jsonObject.add("pattern", gson.toJsonTree((Object)src.pattern));
            }
            return jsonObject;
        }
    }

    public static class Pattern {
        @SerializedName(value="repeatX")
        public int repeatX = 16;
        @SerializedName(value="repeatZ")
        public int repeatZ = 16;
        @SerializedName(value="randomShiftX")
        public int randomShiftX = 0;
        @SerializedName(value="randomShiftZ")
        public int randomShiftZ = 0;
    }
}

