/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.block.RCBlocks;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTNatural;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.BlockExpression;
import ivorius.reccomplex.utils.expression.PositionedBlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerAbstractCloud;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerMulti;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerReplace;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;

public class TransformerNatural
extends TransformerAbstractCloud<InstanceData> {
    public static final double DEFAULT_NATURAL_EXPANSION_DISTANCE = 4.0;
    public static final double DEFAULT_NATURAL_EXPANSION_RANDOMIZATION = 6.0;
    public BlockExpression sourceMatcher;
    public PositionedBlockExpression destMatcher;
    public double naturalExpansionDistance;
    public double naturalExpansionRandomization;

    public TransformerNatural() {
        this(null, BlockExpression.of((MCRegistry)RecurrentComplex.specialRegistry, RCBlocks.genericSolid, 0), 4.0, 6.0);
        this.destMatcher.setExpression("is:replaceable | is:foliage");
    }

    public TransformerNatural(@Nullable String id, String sourceMatcherExpression, double naturalExpansionDistance, double naturalExpansionRandomization) {
        super(id != null ? id : TransformerNatural.randomID(TransformerNatural.class));
        this.sourceMatcher = ExpressionCache.of(new BlockExpression(RecurrentComplex.specialRegistry), sourceMatcherExpression);
        this.destMatcher = ExpressionCache.of(new PositionedBlockExpression(RecurrentComplex.specialRegistry), "");
        this.naturalExpansionDistance = naturalExpansionDistance;
        this.naturalExpansionRandomization = naturalExpansionRandomization;
    }

    public static void addIfNew(List<int[]> list, int ... object) {
        if (!list.contains(object)) {
            list.add(object);
        }
    }

    @Override
    public boolean matches(InstanceData instanceData, IBlockState state) {
        return this.sourceMatcher.test(state);
    }

    @Override
    protected double cloudExpansionDistance(EnumFacing side) {
        return side == EnumFacing.UP ? 0.0 : (side.func_176736_b() >= 0 ? 0.5 : super.cloudExpansionDistance(side));
    }

    @Override
    public boolean canPenetrate(Environment environment, IvWorldData worldData, BlockPos pos, double density, TransformerMulti transformer, TransformerMulti.InstanceData transformerID) {
        return density >= 1.0 || (Boolean)this.destMatcher.evaluate(() -> PositionedBlockExpression.Argument.at((World)environment.world, pos)) != false;
    }

    @Override
    public void transformBlock(InstanceData instanceData, Transformer.Phase phase, StructureSpawnContext context, BlockPos sourcePos, BlockPos pos, IBlockState sourceState, double density) {
        IBlockState setBlock;
        boolean useStoneBlock;
        WorldServer world = context.environment.world;
        Biome biome = context.environment.biome;
        IBlockState topBlock = biome.field_76752_A != null ? biome.field_76752_A : Blocks.field_150350_a.func_176223_P();
        IBlockState fillerBlock = biome.field_76753_B != null ? biome.field_76753_B : Blocks.field_150350_a.func_176223_P();
        IBlockState mainBlock = Blocks.field_150348_b.func_176223_P();
        boolean bl = useStoneBlock = pos.func_177956_o() < world.func_181545_F() - 3;
        IBlockState iBlockState = useStoneBlock ? mainBlock : (setBlock = instanceData.cloud.containsKey((Object)sourcePos.func_177984_a()) ? fillerBlock : topBlock);
        if (world.field_73011_w.getDimension() == -1) {
            setBlock = Blocks.field_150424_aL.func_176223_P();
        } else if (world.field_73011_w.getDimension() == 1) {
            setBlock = Blocks.field_150377_bs.func_176223_P();
        }
        context.setBlock(pos, setBlock, 2);
    }

    @Override
    public double cloudExpansionDistance() {
        return this.naturalExpansionDistance;
    }

    @Override
    public double cloudExpansionRandomization() {
        return this.naturalExpansionRandomization;
    }

    @Override
    public boolean generatesInPhase(InstanceData instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, IvWorldData worldData) {
        return new InstanceData();
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        InstanceData instanceData = new InstanceData();
        instanceData.readFromNBT(nbt);
        return instanceData;
    }

    @Override
    public String getDisplayString() {
        return "Natural: " + this.sourceMatcher.getDisplayString(null);
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTNatural(this, navigator, delegate);
    }

    public static class Serializer
    implements JsonDeserializer<TransformerNatural>,
    JsonSerializer<TransformerNatural> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public TransformerNatural deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.asJsonObject(jsonElement, "transformerNatural");
            String id = Transformer.readID(jsonObject);
            String expression = TransformerReplace.Serializer.readLegacyMatcher(jsonObject, "source", "sourceMetadata");
            if (expression == null) {
                expression = JsonUtils.getString(jsonObject, "sourceExpression", "");
            }
            double naturalExpansionDistance = JsonUtils.getDouble(jsonObject, "naturalExpansionDistance", 4.0);
            double naturalExpansionRandomization = JsonUtils.getDouble(jsonObject, "naturalExpansionRandomization", 6.0);
            TransformerNatural transformer = new TransformerNatural(id, expression, naturalExpansionDistance, naturalExpansionRandomization);
            transformer.destMatcher.setExpression(JsonUtils.getString(jsonObject, "destExpression", "is:replaceable | is:foliage"));
            return transformer;
        }

        public JsonElement serialize(TransformerNatural transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", transformer.id());
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            jsonObject.addProperty("destExpression", transformer.destMatcher.getExpression());
            jsonObject.addProperty("naturalExpansionDistance", (Number)transformer.naturalExpansionDistance);
            jsonObject.addProperty("naturalExpansionRandomization", (Number)transformer.naturalExpansionRandomization);
            return jsonObject;
        }
    }

    public static class InstanceData
    extends TransformerAbstractCloud.InstanceData {
    }
}

