/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTProperty;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.nbt.NBTNone;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.BlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerSingleBlock;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraft.util.text.TextFormatting;

public class TransformerProperty
extends TransformerSingleBlock<NBTNone> {
    public BlockExpression sourceMatcher;
    public String propertyName = "";
    public String propertyValue = "";

    public TransformerProperty() {
        this(null, "", "", "");
    }

    public TransformerProperty(@Nullable String id, String sourceExpression, String propertyName, String propertyValue) {
        super(id != null ? id : TransformerProperty.randomID(TransformerProperty.class));
        this.sourceMatcher = ExpressionCache.of(new BlockExpression(RecurrentComplex.specialRegistry), sourceExpression);
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    @Nonnull
    public static <T extends Comparable<T>> Optional<IBlockState> withProperty(IBlockState state, String propertyName, String propertyValue) {
        Optional<IProperty> mProperty = state.func_177228_b().keySet().stream().filter(p -> p.func_177701_a().equals(propertyName)).findFirst();
        if (mProperty.isPresent()) {
            IProperty property = mProperty.get();
            return property.func_177700_c().stream().filter(v1 -> property.func_177702_a(v1).equals(propertyValue)).findAny().map(v -> state.func_177226_a(property, v));
        }
        return Optional.empty();
    }

    public static Stream<String> propertyValueStream(String propertyName) {
        return Block.field_149771_c.func_148742_b().stream().map(arg_0 -> ((RegistryNamespacedDefaultedByKey)Block.field_149771_c).func_82594_a(arg_0)).map(b -> b.func_176223_P().func_177227_a().stream().filter(p -> p.func_177701_a().equals(propertyName)).findFirst().orElse(null)).filter(Objects::nonNull).flatMap(p -> p.func_177700_c().stream().map(arg_0 -> ((IProperty)p).func_177702_a(arg_0)));
    }

    public static Stream<String> propertyNameStream() {
        return Block.field_149771_c.func_148742_b().stream().map(arg_0 -> ((RegistryNamespacedDefaultedByKey)Block.field_149771_c).func_82594_a(arg_0)).flatMap(b -> b.func_176223_P().func_177227_a().stream().map(IProperty::func_177701_a));
    }

    @Override
    public boolean matches(Environment environment, NBTNone instanceData, IBlockState state) {
        return this.sourceMatcher.test(state) && TransformerProperty.withProperty(state, this.propertyName, this.propertyValue).isPresent();
    }

    @Override
    public void transformBlock(NBTNone instanceData, Transformer.Phase phase, StructureSpawnContext context, int[] areaSize, BlockPos coord, IBlockState sourceState) {
        TransformerProperty.withProperty(sourceState, this.propertyName, this.propertyValue).ifPresent(state -> context.setBlock(coord, (IBlockState)state, 2));
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context, IvWorldData worldData) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    public String getDisplayString() {
        return TextFormatting.GREEN + this.propertyName + TextFormatting.RESET + " -> " + TextFormatting.GREEN + this.propertyValue + TextFormatting.RESET;
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTProperty(this, navigator, delegate);
    }

    @Override
    public boolean generatesInPhase(NBTNone instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    public static class Serializer
    implements JsonDeserializer<TransformerProperty>,
    JsonSerializer<TransformerProperty> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public TransformerProperty deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.asJsonObject(jsonElement, "transformerPropertyReplace");
            String id = Transformer.readID(jsonObject);
            String expression = JsonUtils.getString(jsonObject, "sourceExpression", "");
            String propertyName = JsonUtils.getString(jsonObject, "propertyName", "");
            String propertyValue = JsonUtils.getString(jsonObject, "propertyValue", "");
            return new TransformerProperty(id, expression, propertyName, propertyValue);
        }

        public JsonElement serialize(TransformerProperty transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", transformer.id());
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            jsonObject.addProperty("propertyName", transformer.propertyName);
            jsonObject.addProperty("propertyValue", transformer.propertyValue);
            return jsonObject;
        }
    }
}

