/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import gnu.trove.map.TObjectDoubleMap;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.blocks.IvMutableBlockPos;
import ivorius.ivtoolkit.random.BlurredValueField;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.ivtoolkit.transform.PosTransformer;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.block.BlockGenericSolid;
import ivorius.reccomplex.block.RCBlocks;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTRuins;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.utils.RCAxisAlignedTransform;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLiveContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerAbstractCloud;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class TransformerRuins
extends Transformer<InstanceData> {
    private static final List<BlockPos> neighbors;
    public static final TObjectDoubleMap<Material> stability;
    public EnumFacing decayDirection;
    public float minDecay;
    public float maxDecay;
    public float decayChaos;
    public float decayValueDensity;
    public boolean gravity;
    public float blockErosion;
    public float vineGrowth;
    public float cobwebGrowth;

    public TransformerRuins() {
        this(null, EnumFacing.DOWN, 0.1f, 0.8f, 0.4f, 0.01f, true, 0.3f, 0.05f, 0.02f);
    }

    public TransformerRuins(@Nullable String id, EnumFacing decayDirection, float minDecay, float maxDecay, float decayChaos, float decayValueDensity, boolean gravity, float blockErosion, float vineGrowth, float cobwebGrowth) {
        super(id != null ? id : TransformerRuins.randomID(TransformerRuins.class));
        this.decayDirection = decayDirection;
        this.minDecay = minDecay;
        this.maxDecay = maxDecay;
        this.decayChaos = decayChaos;
        this.decayValueDensity = decayValueDensity;
        this.gravity = gravity;
        this.blockErosion = blockErosion;
        this.vineGrowth = vineGrowth;
        this.cobwebGrowth = cobwebGrowth;
    }

    private static int getPass(IBlockState state) {
        return state.func_185915_l() || state.func_185904_a() == Material.field_151579_a ? 0 : 1;
    }

    public static void shuffleArray(Object[] ar, Random rand) {
        for (int i = ar.length - 1; i > 0; --i) {
            int index = rand.nextInt(i + 1);
            Object a = ar[index];
            ar[index] = ar[i];
            ar[i] = a;
        }
    }

    public static int product(int[] surfaceSize) {
        return Arrays.stream(surfaceSize).reduce(1, (left, right) -> left * right);
    }

    @Nonnull
    protected static IBlockState randomPlacement(Random random, IBlockState stairs) {
        return stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.func_176731_b((int)random.nextInt(4))).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)(random.nextBoolean() ? BlockStairs.EnumHalf.BOTTOM : BlockStairs.EnumHalf.TOP));
    }

    @Override
    public boolean skipGeneration(InstanceData instanceData, StructureLiveContext context, BlockPos pos, IBlockState state, IvWorldData worldData, BlockPos sourcePos) {
        if (instanceData.fallingBlocks.contains(sourcePos)) {
            return true;
        }
        double decay = this.getDecay(instanceData, sourcePos, state);
        if (decay < 1.0E-6) {
            return false;
        }
        if (decay > 1.0) {
            return true;
        }
        return this.getStability(worldData, sourcePos) < decay;
    }

    public double getDecay(InstanceData instanceData, BlockPos sourcePos, IBlockState state) {
        return Math.pow(instanceData.getDecay(sourcePos), stability.get((Object)state.func_185904_a()));
    }

    public double getStability(IvWorldData worldData, BlockPos sourcePos) {
        double stability = (double)this.decayDirection.func_82601_c() * ((double)(sourcePos.func_177958_n() + 1) / (double)(worldData.blockCollection.getWidth() + 1)) + (double)this.decayDirection.func_96559_d() * ((double)(sourcePos.func_177956_o() + 1) / (double)(worldData.blockCollection.getHeight() + 1)) + (double)this.decayDirection.func_82599_e() * ((double)(sourcePos.func_177952_p() + 1) / (double)(worldData.blockCollection.getLength() + 1));
        if (stability < 0.0) {
            stability += 1.0;
        }
        return stability;
    }

    @Override
    public void transform(InstanceData instanceData, Transformer.Phase phase, StructureSpawnContext context, IvWorldData worldData, RunTransformer transformer) {
        if (phase == Transformer.Phase.AFTER) {
            WorldServer world = context.environment.world;
            IvBlockCollection blockCollection = worldData.blockCollection;
            int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
            BlockPos lowerCoord = StructureBoundingBoxes.min(context.boundingBox);
            HashMap<BlockPos, NBTTagCompound> tileEntityCompounds = new HashMap<BlockPos, NBTTagCompound>();
            for (NBTTagCompound nBTTagCompound : worldData.tileEntities) {
                BlockPos key = new BlockPos(nBTTagCompound.func_74762_e("x"), nBTTagCompound.func_74762_e("y"), nBTTagCompound.func_74762_e("z"));
                tileEntityCompounds.put(key, nBTTagCompound);
            }
            BlockPos.MutableBlockPos dest = new BlockPos.MutableBlockPos(lowerCoord);
            for (BlockPos sourcePos : instanceData.fallingBlocks) {
                IBlockState iBlockState;
                IBlockState source = blockCollection.getBlockState(sourcePos);
                if (!this.canLand(source)) continue;
                IvMutableBlockPos.add(context.transform.applyOn(sourcePos, dest, areaSize), lowerCoord);
                while (dest.func_177956_o() > 0 && (iBlockState = world.func_180495_p((BlockPos)dest)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)dest)) {
                    IvMutableBlockPos.offset((BlockPos)dest, dest, EnumFacing.DOWN);
                }
                IvMutableBlockPos.offset((BlockPos)dest, dest, EnumFacing.UP);
                IBlockState state = PosTransformer.transformBlockState(source, context.transform);
                GenericStructure.setBlock(context, areaSize, (BlockPos)dest, state, () -> (NBTTagCompound)tileEntityCompounds.get(sourcePos));
            }
            StructureBoundingBox structureBoundingBox = context.boundingBox;
            RecurrentComplex.forgeEventHandler.disabledTileDropAreas.add(structureBoundingBox);
            if (this.blockErosion > 0.0f || this.vineGrowth > 0.0f) {
                StructureBoundingBox relevantBB = context.generationBB != null ? Structures.intersection(context.boundingBox, context.generationBB) : context.boundingBox;
                for (BlockPos blockPos : BlockAreas.mutablePositions(blockCollection.area())) {
                    IBlockState state;
                    BlockPos worldCoord = context.transform.apply(blockPos, areaSize).func_177971_a((Vec3i)StructureBoundingBoxes.min(context.boundingBox));
                    if (!context.includes((Vec3i)worldCoord) || transformer.transformer.skipGeneration(transformer.instanceData, (StructureLiveContext)context, worldCoord, state = world.func_180495_p(worldCoord), worldData, blockPos)) continue;
                    this.decayBlock((World)world, context.random, state, worldCoord, relevantBB);
                }
            }
            RecurrentComplex.forgeEventHandler.disabledTileDropAreas.remove(structureBoundingBox);
        }
    }

    public void decayBlock(World world, Random random, IBlockState state, BlockPos pos, StructureBoundingBox boundingBox) {
        IBlockState newState = state;
        if (random.nextFloat() < this.blockErosion) {
            if (newState.func_177230_c() == Blocks.field_150417_aV && newState.func_177228_b().get((Object)BlockStoneBrick.field_176249_a) != BlockStoneBrick.EnumType.MOSSY) {
                newState = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED);
            } else if (newState.func_177230_c() == Blocks.field_150322_A) {
                newState = Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.DEFAULT);
            }
        }
        newState = this.maybeErodeShape(random, newState, Blocks.field_150417_aV, BlockStoneBrick.field_176249_a, BlockStoneBrick.EnumType.DEFAULT, Blocks.field_150390_bg);
        newState = this.maybeErodeShape(random, newState, Blocks.field_150344_f, BlockPlanks.field_176383_a, BlockPlanks.EnumType.OAK, Blocks.field_150476_ad);
        newState = this.maybeErodeShape(random, newState, Blocks.field_150344_f, BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE, Blocks.field_150485_bF);
        newState = this.maybeErodeShape(random, newState, Blocks.field_150344_f, BlockPlanks.field_176383_a, BlockPlanks.EnumType.BIRCH, Blocks.field_150487_bG);
        newState = this.maybeErodeShape(random, newState, Blocks.field_150344_f, BlockPlanks.field_176383_a, BlockPlanks.EnumType.JUNGLE, Blocks.field_150481_bH);
        newState = this.maybeErodeShape(random, newState, Blocks.field_150344_f, BlockPlanks.field_176383_a, BlockPlanks.EnumType.ACACIA, Blocks.field_150400_ck);
        newState = this.maybeErodeShape(random, newState, Blocks.field_150344_f, BlockPlanks.field_176383_a, BlockPlanks.EnumType.DARK_OAK, Blocks.field_150401_cl);
        newState = this.maybeErodeShape(random, newState, Blocks.field_150322_A, null, null, Blocks.field_150372_bz);
        newState = this.maybeErodeShape(random, newState, Blocks.field_150347_e, null, null, Blocks.field_150446_ar);
        newState = this.maybeErodeShape(random, newState, Blocks.field_150371_ca, null, null, Blocks.field_150370_cb);
        newState = this.maybeErodeShape(random, newState, Blocks.field_180395_cM, null, null, Blocks.field_180396_cN);
        newState = this.maybeErodeShape(random, newState, Blocks.field_150385_bj, null, null, Blocks.field_150387_bl);
        if (random.nextFloat() < this.vineGrowth) {
            if (newState.func_177230_c() == Blocks.field_150417_aV) {
                newState = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
            } else if (newState.func_177230_c() == Blocks.field_150347_e) {
                newState = Blocks.field_150341_Y.func_176223_P();
            } else if (newState.func_177230_c() == Blocks.field_150463_bK) {
                newState = Blocks.field_150463_bK.func_176223_P().func_177226_a((IProperty)BlockWall.field_176255_P, (Comparable)BlockWall.EnumType.MOSSY);
            }
        }
        if (newState.func_177230_c() == Blocks.field_150350_a) {
            newState = null;
            for (EnumFacing direction : EnumFacing.field_176754_o) {
                if (random.nextFloat() < this.vineGrowth && boundingBox.func_175898_b((Vec3i)pos.func_177972_a(direction.func_176734_d())) && Blocks.field_150395_bd.func_176198_a(world, pos, direction)) {
                    BlockPos downPos;
                    IBlockState downState = world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
                    downState = downState.func_177230_c() == Blocks.field_150395_bd ? downState : Blocks.field_150395_bd.func_176223_P();
                    downState = downState.func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)direction.func_176734_d()), (Comparable)Boolean.valueOf(true));
                    int length = 1 + random.nextInt(MathHelper.func_76141_d((float)(this.vineGrowth * 10.0f + 3.0f)));
                    for (int y = 0; y < length && world.func_180495_p(downPos = pos.func_177967_a(EnumFacing.DOWN, y)).func_185904_a() == Material.field_151579_a; ++y) {
                        world.func_180501_a(downPos, downState, 3);
                    }
                    break;
                }
                if (!(random.nextFloat() < this.cobwebGrowth) || !this.hasAirNeighbors(world, pos, 3)) continue;
                newState = null;
                world.func_180501_a(pos, Blocks.field_150321_G.func_176223_P(), 3);
            }
        }
        if (newState != null && state != newState) {
            world.func_180501_a(pos, newState, 3);
        }
    }

    @Nonnull
    protected IBlockState maybeErodeShape(Random random, IBlockState newState, Block block, PropertyEnum<?> variant, Object value, Block oakStairs) {
        if (newState.func_177230_c() == block && (variant == null || newState.func_177228_b().get(variant) == value)) {
            newState = this.erodeShape(random, newState, oakStairs);
        }
        return newState;
    }

    @Nonnull
    protected IBlockState erodeShape(Random random, IBlockState newState, Block stairs) {
        if (random.nextFloat() < this.blockErosion * 0.125f) {
            newState = TransformerRuins.randomPlacement(random, stairs.func_176223_P());
        }
        return newState;
    }

    public boolean hasAirNeighbors(World world, BlockPos pos, int sides) {
        int num = 0;
        int neg = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (world.func_180495_p(pos.func_177972_a(facing)).func_185915_l()) {
                ++num;
            } else {
                ++neg;
            }
            if (num >= sides) {
                return true;
            }
            if (neg <= 6 - sides) continue;
            return false;
        }
        throw new InternalError();
    }

    @Override
    public String getDisplayString() {
        return IvTranslations.get("reccomplex.transformer.ruins");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTRuins(this, navigator, delegate);
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, IvWorldData worldData) {
        InstanceData instanceData = new InstanceData();
        if (this.minDecay > 0.0f || this.maxDecay > 0.0f) {
            BlockArea sourceArea = BlockArea.areaFromSize(BlockPos.field_177992_a, StructureBoundingBoxes.size(context.boundingBox));
            double decayChaos = (context.random.nextDouble() * 0.5 + 0.5) * (double)this.decayChaos;
            instanceData.baseDecay = context.random.nextDouble() * (double)(this.maxDecay - this.minDecay) + (double)this.minDecay;
            int[] surfaceSize = BlockAreas.side(sourceArea, this.decayDirection).areaSize();
            instanceData.surfaceField = new BlurredValueField(surfaceSize);
            int surfaceValues = MathHelper.func_76128_c((double)((double)((float)TransformerRuins.product(surfaceSize) * this.decayValueDensity) + 0.5));
            for (int i = 0; i < surfaceValues; ++i) {
                instanceData.surfaceField.addValue((context.random.nextDouble() - context.random.nextDouble()) * decayChaos * 1.25, context.random);
            }
            int[] volumeSize = sourceArea.areaSize();
            instanceData.volumeField = new BlurredValueField(volumeSize);
            int volumeValues = MathHelper.func_76128_c((double)((double)((float)TransformerRuins.product(volumeSize) * this.decayValueDensity) * 0.25 + 0.5));
            for (int i = 0; i < volumeValues; ++i) {
                instanceData.volumeField.addValue((context.random.nextDouble() - context.random.nextDouble()) * decayChaos * 0.75, context.random);
            }
            instanceData.clearDecayCache();
        }
        return instanceData;
    }

    @Override
    public void configureInstanceData(InstanceData instanceData, StructurePrepareContext context, IvWorldData worldData, RunTransformer transformer) {
        if (this.gravity) {
            IvBlockCollection blockCollection = worldData.blockCollection;
            int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
            BlockPos lowerCoord = StructureBoundingBoxes.min(context.boundingBox);
            BlockPos.MutableBlockPos dest = new BlockPos.MutableBlockPos(lowerCoord);
            for (BlockPos blockPos : BlockAreas.mutablePositions(blockCollection.area())) {
                IBlockState state = blockCollection.getBlockState(blockPos);
                IvMutableBlockPos.add(RCAxisAlignedTransform.apply(blockPos, dest, areaSize, context.transform), lowerCoord);
                if (transformer.transformer.skipGeneration(transformer.instanceData, (StructureLiveContext)context, (BlockPos)dest, state, worldData, blockPos) || !this.canFall(context, worldData, transformer, dest, blockPos, state)) continue;
                double stability = this.getStability(worldData, blockPos);
                double decay = this.getDecay(instanceData, blockPos, state);
                double stabilitySQ = stability * stability;
                if (stability < decay || !(stabilitySQ * stabilitySQ < decay)) continue;
                instanceData.fallingBlocks.add(blockPos.func_185334_h());
            }
            HashSet complete = new HashSet(TransformerRuins.product(areaSize));
            HashSet hashSet = new HashSet();
            boolean[] hasFloor = new boolean[1];
            for (BlockPos startPos : BlockAreas.positions(blockCollection.area())) {
                if (complete.contains(startPos)) continue;
                hasFloor[0] = false;
                hashSet.clear();
                TransformerAbstractCloud.visitRecursively(Sets.newHashSet((Object[])new BlockPos[]{startPos}), (changed, sourcePos) -> {
                    if (!complete.add(sourcePos) || instanceData.fallingBlocks.contains(sourcePos)) {
                        return true;
                    }
                    IvMutableBlockPos.add(RCAxisAlignedTransform.apply(sourcePos, dest, areaSize, context.transform), lowerCoord);
                    IBlockState state = blockCollection.getBlockState((BlockPos)sourcePos);
                    if (this.canFall(context, worldData, transformer, dest, (BlockPos)sourcePos, state)) {
                        if (state.func_177230_c() == RCBlocks.genericSolid && (Integer)state.func_177229_b((IProperty)BlockGenericSolid.TYPE) == 0) {
                            hasFloor[0] = true;
                        }
                        connected.add(sourcePos);
                        neighbors.stream().map(arg_0 -> ((BlockPos)sourcePos).func_177971_a(arg_0)).forEach(changed::add);
                    }
                    return true;
                });
                if (hashSet.size() <= 0 || hashSet.size() >= 200 || hasFloor[0]) continue;
                instanceData.fallingBlocks.addAll(hashSet);
            }
        }
    }

    public boolean canLand(IBlockState state) {
        return state.func_185904_a().func_186274_m() == EnumPushReaction.NORMAL && state.func_185915_l();
    }

    public boolean canFall(StructurePrepareContext context, IvWorldData worldData, RunTransformer transformer, BlockPos.MutableBlockPos dest, BlockPos worldPos, IBlockState state) {
        return !transformer.transformer.skipGeneration(transformer.instanceData, (StructureLiveContext)context, (BlockPos)dest, state, worldData, worldPos) && state.func_185904_a() != Material.field_151579_a;
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
    }

    static {
        stability = new TObjectDoubleHashMap(10, 0.5f, 1.0);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    builder.add((Object)new BlockPos(x, y, z));
                }
            }
        }
        neighbors = builder.build();
        stability.put((Object)Material.field_151592_s, 0.1);
        stability.put((Object)Material.field_151587_i, 2.0);
        stability.put((Object)Material.field_151594_q, 0.2);
        stability.put((Object)Material.field_151573_f, 2.0);
        stability.put((Object)Material.field_151575_d, 0.3);
        stability.put((Object)Material.field_151580_n, 0.3);
    }

    public static class Serializer
    implements JsonDeserializer<TransformerRuins>,
    JsonSerializer<TransformerRuins> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public TransformerRuins deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.asJsonObject(jsonElement, "transformerRuins");
            String id = Transformer.readID(jsonObject);
            EnumFacing decayDirection = Directions.deserialize(JsonUtils.getString(jsonObject, "decayDirection", "DOWN"));
            float minDecay = JsonUtils.getFloat(jsonObject, "minDecay", 0.0f);
            float maxDecay = JsonUtils.getFloat(jsonObject, "maxDecay", 0.9f);
            float decayChaos = JsonUtils.getFloat(jsonObject, "decayChaos", 0.3f);
            float decayValueDensity = JsonUtils.getFloat(jsonObject, "decayValueDensity", 0.04f);
            boolean gravity = JsonUtils.getBoolean(jsonObject, "gravity", true);
            float blockErosion = JsonUtils.getFloat(jsonObject, "blockErosion", 0.0f);
            float vineGrowth = JsonUtils.getFloat(jsonObject, "vineGrowth", 0.0f);
            float cobwebGrowth = JsonUtils.getFloat(jsonObject, "cobwebGrowth", 0.0f);
            return new TransformerRuins(id, decayDirection, minDecay, maxDecay, decayChaos, decayValueDensity, gravity, blockErosion, vineGrowth, cobwebGrowth);
        }

        public JsonElement serialize(TransformerRuins transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", transformer.id());
            jsonObject.addProperty("decayDirection", Directions.serialize(transformer.decayDirection));
            jsonObject.addProperty("minDecay", (Number)Float.valueOf(transformer.minDecay));
            jsonObject.addProperty("maxDecay", (Number)Float.valueOf(transformer.maxDecay));
            jsonObject.addProperty("decayChaos", (Number)Float.valueOf(transformer.decayChaos));
            jsonObject.addProperty("decayValueDensity", (Number)Float.valueOf(transformer.decayValueDensity));
            jsonObject.addProperty("gravity", Boolean.valueOf(transformer.gravity));
            jsonObject.addProperty("blockErosion", (Number)Float.valueOf(transformer.blockErosion));
            jsonObject.addProperty("vineGrowth", (Number)Float.valueOf(transformer.vineGrowth));
            jsonObject.addProperty("cobwebGrowth", (Number)Float.valueOf(transformer.cobwebGrowth));
            return jsonObject;
        }
    }

    public static class InstanceData
    implements NBTStorable {
        public Double baseDecay;
        public BlurredValueField surfaceField;
        public BlurredValueField volumeField;
        public final Set<BlockPos> fallingBlocks = new HashSet<BlockPos>();
        public Double[] decayCache;
        public int[] decayCacheSize;

        public InstanceData() {
        }

        public InstanceData(NBTTagCompound compound) {
            this.baseDecay = compound.func_74764_b("baseDecay") ? Double.valueOf(compound.func_74769_h("baseDecay")) : null;
            this.surfaceField = compound.func_150297_b("field", 10) ? NBTCompoundObjects.read(compound.func_74775_l("field"), BlurredValueField::new) : null;
            this.volumeField = compound.func_150297_b("volumeField", 10) ? NBTCompoundObjects.read(compound.func_74775_l("volumeField"), BlurredValueField::new) : null;
            this.fallingBlocks.addAll(NBTTagLists.intArraysFrom(compound, "fallingBlocks").stream().map(BlockPositions::fromIntArray).collect(Collectors.toList()));
            this.clearDecayCache();
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            if (this.baseDecay != null) {
                compound.func_74780_a("baseDecay", this.baseDecay.doubleValue());
            }
            if (this.surfaceField != null) {
                compound.func_74782_a("field", (NBTBase)NBTCompoundObjects.write(this.surfaceField));
            }
            if (this.volumeField != null) {
                compound.func_74782_a("volumeField", (NBTBase)NBTCompoundObjects.write(this.volumeField));
            }
            NBTTagLists.writeIntArraysTo(compound, "fallingBlocks", this.fallingBlocks.stream().map(BlockPositions::toIntArray).collect(Collectors.toList()));
            return compound;
        }

        private Integer getIndex(BlockPos pos) {
            if (this.decayCacheSize == null) {
                return null;
            }
            if (pos.func_177958_n() < 0 || pos.func_177956_o() < 0 || pos.func_177952_p() < 0 || pos.func_177958_n() >= this.decayCacheSize[0] || pos.func_177956_o() >= this.decayCacheSize[1] || pos.func_177952_p() >= this.decayCacheSize[2]) {
                return null;
            }
            return (pos.func_177958_n() * this.decayCacheSize[1] + pos.func_177956_o()) * this.decayCacheSize[2] + pos.func_177952_p();
        }

        public double getDecay(BlockPos pos) {
            if (!this.hasDecay()) {
                return 0.0;
            }
            Integer index = this.getIndex(pos);
            if (index != null) {
                Double decay = this.decayCache[index];
                return decay != null ? decay : (this.decayCache[index.intValue()] = Double.valueOf(this.calculateDecay(pos)));
            }
            return this.calculateDecay(pos);
        }

        public void clearDecayCache() {
            if (this.volumeField != null) {
                this.decayCacheSize = this.volumeField.getSize();
                this.decayCache = new Double[TransformerRuins.product(this.decayCacheSize)];
            } else {
                this.decayCacheSize = null;
                this.decayCache = null;
            }
        }

        protected boolean hasDecay() {
            return this.baseDecay != null || this.surfaceField != null || this.volumeField != null;
        }

        protected double calculateDecay(BlockPos pos) {
            return (this.baseDecay != null ? this.baseDecay : 0.0) + (this.surfaceField != null ? this.surfaceField.getValue(Math.min(pos.func_177958_n(), this.surfaceField.getSize()[0]), Math.min(pos.func_177956_o(), this.surfaceField.getSize()[1]), Math.min(pos.func_177952_p(), this.surfaceField.getSize()[2])) : 0.0) + (this.volumeField != null ? this.volumeField.getValue(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) : 0.0);
        }
    }
}

