/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.transform.PosTransformer;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTBiomeSpecific;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.nbt.NBTNone;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.BlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.WeightedBlockState;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerSingleBlock;
import java.lang.reflect.Type;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class TransformerVillageSpecific
extends TransformerSingleBlock<NBTNone> {
    public final MyVillage village = new MyVillage();
    public BlockExpression sourceMatcher;

    public TransformerVillageSpecific() {
        this(null, "");
    }

    public TransformerVillageSpecific(@Nullable String id, String sourceExpression) {
        super(id != null ? id : TransformerVillageSpecific.randomID(TransformerVillageSpecific.class));
        this.sourceMatcher = ExpressionCache.of(new BlockExpression(RecurrentComplex.specialRegistry), sourceExpression);
    }

    @Override
    public boolean matches(Environment environment, NBTNone instanceData, IBlockState state) {
        return this.village.trySetType(environment.villageType) && this.sourceMatcher.test(state) && this.village.func_175847_a(state) != state;
    }

    @Override
    public void transformBlock(NBTNone instanceData, Transformer.Phase phase, StructureSpawnContext context, int[] areaSize, BlockPos coord, IBlockState sourceState) {
        if (this.village.trySetType(context.environment.villageType)) {
            IBlockState state = this.village.func_175847_a(sourceState);
            context.setBlock(coord, PosTransformer.transformBlockState(state, context.transform), 2);
        }
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context, IvWorldData worldData) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    public String getDisplayString() {
        return IvTranslations.get("reccomplex.transformer.villagereplace");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTBiomeSpecific(this, navigator, delegate);
    }

    @Override
    public boolean generatesInPhase(NBTNone instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    private static class MyVillage
    extends StructureVillagePieces.Village {
        private MyVillage() {
        }

        public boolean trySetType(@Nullable Integer type) {
            if (type != null) {
                this.field_189928_h = type;
            }
            return type != null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            return false;
        }

        public IBlockState func_175847_a(IBlockState blockstateIn) {
            return super.func_175847_a(blockstateIn);
        }
    }

    public static class Serializer
    implements JsonDeserializer<TransformerVillageSpecific>,
    JsonSerializer<TransformerVillageSpecific> {
        private MCRegistry registry;
        private Gson gson;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
            this.gson = new GsonBuilder().registerTypeAdapter(WeightedBlockState.class, (Object)new WeightedBlockState.Serializer(registry)).create();
        }

        public TransformerVillageSpecific deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.asJsonObject(jsonElement, "transformerReplace");
            String id = Transformer.readID(jsonObject);
            String expression = JsonUtils.getString(jsonObject, "sourceExpression", "");
            return new TransformerVillageSpecific(id, expression);
        }

        public JsonElement serialize(TransformerVillageSpecific transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", transformer.id());
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            return jsonObject;
        }
    }
}

