/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.script;

import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.IvCollections;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.block.SpawnCommandLogic;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.worldscripts.command.TableDataSourceWorldScriptCommand;
import ivorius.reccomplex.nbt.NBTNone;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.script.WorldScript;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldScriptCommand
implements WorldScript<NBTNone> {
    public List<Entry> entries = new ArrayList<Entry>();

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void setEntries(List<Entry> entries) {
        IvCollections.setContentsOfList(this.entries, entries);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.entries.clear();
        NBTTagList entryNBTs = nbtTagCompound.func_150295_c("commands", 10);
        for (int i = 0; i < entryNBTs.func_74745_c(); ++i) {
            this.entries.add(new Entry(entryNBTs.func_150305_b(i)));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList structureNBTList = new NBTTagList();
        for (Entry entry : this.entries) {
            structureNBTList.func_74742_a((NBTBase)entry.writeToNBT());
        }
        nbtTagCompound.func_74782_a("commands", (NBTBase)structureNBTList);
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context, BlockPos pos) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    public void generate(final StructureSpawnContext context, NBTNone instanceData, final BlockPos pos) {
        if (context.includes((Vec3i)pos) && this.entries.size() > 0) {
            Entry entry = WeightedSelector.selectItem(context.random, this.entries);
            if (entry.command.trim().isEmpty()) {
                return;
            }
            SpawnCommandLogic logic = new SpawnCommandLogic(){

                public BlockPos func_180425_c() {
                    return pos;
                }

                public Vec3d func_174791_d() {
                    return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                }

                public World func_130014_f_() {
                    return context.environment.world;
                }

                @Override
                public void updateCommand() {
                    IBlockState iblockstate = context.environment.world.func_180495_p(pos);
                    context.environment.world.func_184138_a(pos, iblockstate, iblockstate, 3);
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public int getCommandBlockType() {
                    return 0;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void fillInInfo(ByteBuf buf) {
                    buf.writeInt(pos.func_177958_n());
                    buf.writeInt(pos.func_177956_o());
                    buf.writeInt(pos.func_177952_p());
                }

                public Entity func_174793_f() {
                    return null;
                }

                public MinecraftServer func_184102_h() {
                    return context.environment.world.func_73046_m();
                }
            };
            logic.setCommand(entry.command);
            try {
                logic.trigger((World)context.environment.world);
            }
            catch (Exception t) {
                RecurrentComplex.logger.error("Error executing command '%s'", new Object[]{entry.command});
                RecurrentComplex.logger.error("Command execution failed", (Throwable)t);
            }
        }
    }

    @Override
    public String getDisplayString() {
        return IvTranslations.get("reccomplex.worldscript.command");
    }

    @Override
    public TableDataSource tableDataSource(BlockPos realWorldPos, TableNavigator navigator, TableDelegate tableDelegate) {
        return new TableDataSourceWorldScriptCommand(this, tableDelegate, navigator);
    }

    public static class Entry
    implements WeightedSelector.Item {
        public String command;
        public Double weight;

        public Entry(Double weight, String command) {
            this.command = command;
            this.weight = weight;
        }

        public Entry(NBTTagCompound compound) {
            this.command = compound.func_74779_i("command");
            this.weight = compound.func_150297_b("weight", 6) ? Double.valueOf(compound.func_74769_h("weight")) : (compound.func_150297_b("weight", 3) ? Double.valueOf((double)compound.func_74762_e("weight") * 0.01) : null);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("command", this.command);
            if (this.weight != null) {
                compound.func_74780_a("weight", this.weight.doubleValue());
            }
            return compound;
        }

        @Override
        public double getWeight() {
            return this.weight != null ? this.weight : 1.0;
        }

        public boolean hasDefaultWeight() {
            return this.weight == null;
        }
    }
}

