/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.storage.loot;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.json.ItemStackSerializer;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.json.NBTToJson;
import ivorius.reccomplex.utils.expression.DependencyExpression;
import ivorius.reccomplex.world.storage.loot.InventoryLoadException;
import ivorius.reccomplex.world.storage.loot.ItemCollectionSaveHandler;
import ivorius.reccomplex.world.storage.loot.WeightedItemCollection;
import ivorius.reccomplex.world.storage.loot.WeightedRandomChestContent;
import ivorius.reccomplex.world.storage.loot.WeightedRandomChestContentSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.WorldServer;

public class GenericItemCollection
implements WeightedItemCollection {
    public static final int LATEST_VERSION = 2;
    private static Gson gson = GenericItemCollection.createGson();
    public final List<Component> components = new ArrayList<Component>();

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Component.class, (Object)new Component.Serializer());
        builder.registerTypeAdapter(RandomizedItemStack.class, (Object)new RandomizedItemStack.Serializer());
        builder.registerTypeAdapter(ItemStack.class, (Object)new ItemStackSerializer(RecurrentComplex.specialRegistry));
        builder.registerTypeAdapter(WeightedRandomChestContent.class, (Object)new WeightedRandomChestContentSerializer());
        NBTToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    @Override
    public ItemStack getRandomItemStack(WorldServer server, Random random) {
        int max = 0;
        for (Component component : this.components) {
            component.updateWeightCache();
            max += component.field_76292_a;
        }
        if (max > 0) {
            return ((Component)WeightedRandom.func_76273_a((Random)random, this.components, (int)max)).getRandomItemStack(random);
        }
        return null;
    }

    @Override
    public String getDescriptor() {
        return IvTranslations.get("inventoryGen.custom");
    }

    public static class RandomizedItemStack
    implements WeightedSelector.Item {
        public ItemStack itemStack;
        public int min;
        public int max;
        public double weight;

        public RandomizedItemStack(ItemStack itemStack, int min, int max, double weight) {
            this.itemStack = itemStack;
            this.min = min;
            this.max = max;
            this.weight = weight;
        }

        public static RandomizedItemStack from(WeightedRandomChestContent chestContent, int defaultWeight) {
            return new RandomizedItemStack(chestContent.theItemId.func_77946_l(), chestContent.minStackSize, chestContent.maxStackSize, (double)chestContent.itemWeight / (double)defaultWeight);
        }

        public ItemStack generateStack(Random random) {
            int min = Math.min(this.max, this.min);
            int max = Math.max(this.max, this.min);
            ItemStack stack = this.itemStack.func_77946_l();
            stack.field_77994_a = random.nextInt(max - min + 1) + min;
            return stack;
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        public static class Serializer
        implements JsonDeserializer<RandomizedItemStack>,
        JsonSerializer<RandomizedItemStack> {
            public RandomizedItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = JsonUtils.asJsonObject(json, "randomizedItem");
                double weight = JsonUtils.getDouble(jsonObject, "weight");
                int min = JsonUtils.getInt(jsonObject, "min");
                int max = JsonUtils.getInt(jsonObject, "max");
                ItemStack stack = (ItemStack)context.deserialize(jsonObject.get("item"), ItemStack.class);
                return new RandomizedItemStack(stack, min, max, weight);
            }

            public JsonElement serialize(RandomizedItemStack src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("weight", (Number)src.weight);
                jsonObject.addProperty("min", (Number)src.min);
                jsonObject.addProperty("max", (Number)src.max);
                jsonObject.add("item", context.serialize((Object)src.itemStack));
                return jsonObject;
            }
        }
    }

    public static class Component
    extends WeightedRandom.Item {
        public final List<RandomizedItemStack> items = new ArrayList<RandomizedItemStack>();
        public final DependencyExpression dependencies = new DependencyExpression();
        public String inventoryGeneratorID;

        public Component() {
            super(0);
            this.inventoryGeneratorID = "";
        }

        public Component(String inventoryGeneratorID, List<RandomizedItemStack> items, String dependencies) {
            super(0);
            this.inventoryGeneratorID = inventoryGeneratorID;
            this.items.addAll(items);
            this.dependencies.setExpression(dependencies);
        }

        public static Component createDefaultComponent() {
            return new Component();
        }

        public ItemStack getRandomItemStack(Random random) {
            if (this.items.size() == 0) {
                return null;
            }
            RandomizedItemStack item = WeightedSelector.selectItem(random, this.items);
            return item.generateStack(random);
        }

        public boolean areDependenciesResolved() {
            return this.dependencies.test(RecurrentComplex.saver);
        }

        public void updateWeightCache() {
            this.field_76292_a = this.items.size();
        }

        public Component copy() {
            try {
                return ItemCollectionSaveHandler.INSTANCE.fromJSON(ItemCollectionSaveHandler.INSTANCE.toJSON(this));
            }
            catch (InventoryLoadException e) {
                e.printStackTrace();
                return null;
            }
        }

        public static class Serializer
        implements JsonDeserializer<Component>,
        JsonSerializer<Component> {
            public Component deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
                int version;
                JsonObject jsonObject = JsonUtils.asJsonObject(jsonElement, "status");
                if (jsonObject.has("version")) {
                    version = JsonUtils.getInt(jsonObject, "version");
                } else {
                    version = 2;
                    RecurrentComplex.logger.warn("InventoryGen JSON missing 'version', using latest (2)");
                }
                String generatorID = JsonUtils.getString(jsonObject, "inventoryGeneratorID", "");
                ArrayList<RandomizedItemStack> stacks = new ArrayList<RandomizedItemStack>();
                if (jsonObject.has("items")) {
                    stacks.addAll(Lists.newArrayList((Object[])((Object[])gson.fromJson(jsonObject.get("items"), RandomizedItemStack[].class))));
                }
                if (version == 1 && jsonObject.has("contents")) {
                    ArrayList chestContents = Lists.newArrayList((Object[])((Object[])gson.fromJson(jsonObject.get("contents"), WeightedRandomChestContent[].class)));
                    stacks.addAll(Collections2.transform((Collection)chestContents, input -> RandomizedItemStack.from(input, 100)));
                }
                String dependencyExpression = JsonUtils.getString(jsonObject, "dependencyExpression", "");
                if (version == 1 && jsonObject.has("dependencies")) {
                    String[] dependencies = (String[])context.deserialize(jsonObject.get("dependencies"), String[].class);
                    dependencyExpression = DependencyExpression.ofMods(dependencies);
                }
                return new Component(generatorID, stacks, dependencyExpression);
            }

            public JsonElement serialize(Component src, Type par2Type, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("version", (Number)2);
                jsonObject.addProperty("inventoryGeneratorID", src.inventoryGeneratorID);
                jsonObject.add("items", gson.toJsonTree(src.items));
                jsonObject.add("dependencyExpression", context.serialize((Object)src.dependencies.getExpression()));
                return jsonObject;
            }
        }
    }
}

