/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.storage.loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import io.netty.buffer.ByteBuf;
import ivorius.reccomplex.json.NBTToJson;
import ivorius.reccomplex.world.storage.loot.GenericItemCollection;
import ivorius.reccomplex.world.storage.loot.InventoryLoadException;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ItemCollectionSaveHandler {
    public static final ItemCollectionSaveHandler INSTANCE = new ItemCollectionSaveHandler();
    private Gson gson = this.createGson();

    public Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(GenericItemCollection.Component.class, (Object)new GenericItemCollection.Component.Serializer());
        NBTToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    public void write(ByteBuf data, GenericItemCollection.Component component) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.toJSON(component));
    }

    @Nullable
    public GenericItemCollection.Component read(ByteBuf data) {
        try {
            return this.fromJSON(ByteBufUtils.readUTF8String((ByteBuf)data));
        }
        catch (InventoryLoadException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toJSON(GenericItemCollection.Component inventoryGenerator) {
        return this.gson.toJson((Object)inventoryGenerator, GenericItemCollection.Component.class);
    }

    public GenericItemCollection.Component fromJSON(String json) throws InventoryLoadException {
        try {
            return (GenericItemCollection.Component)((Object)this.gson.fromJson(json, GenericItemCollection.Component.class));
        }
        catch (JsonSyntaxException e) {
            throw new InventoryLoadException(e);
        }
    }
}

