/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.commands.structure.CommandSearchStructure;
import ivorius.reccomplex.files.RCFiles;
import ivorius.reccomplex.files.loading.ResourceDirectory;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.world.gen.feature.selector.StructureSelector;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.ListGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.MazeGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.NaturalGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.SaplingGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.StaticGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.VanillaDecorationGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.VanillaGeneration;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.PriorityQueue;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class CommandSanity
extends CommandExpecting {
    public static <K, T> Stream<T> values(IRegistry<K, T> registry) {
        return registry.func_148742_b().stream().map(arg_0 -> registry.func_82594_a(arg_0));
    }

    public static Stream<World> dimensions(MinecraftServer server) {
        return Stream.of(DimensionManager.getIDs()).map(arg_0 -> ((MinecraftServer)server).func_71218_a(arg_0));
    }

    public String func_71517_b() {
        return RCConfig.commandPrefix + "sanity";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void expect(Expect expect) {
        expect.flag("silent", new String[0]).flag("short", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        boolean sane = true;
        if (StructureRegistry.INSTANCE.ids().isEmpty()) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString("No registered structures!"));
            sane = false;
        }
        if (!Files.isReadable(ResourceDirectory.getCustomDirectory().toPath())) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString("Can't read files from custom directory"));
            sane = false;
        }
        for (ModContainer mod : Loader.instance().getModList()) {
            String domain = mod.getModId();
            Path path = null;
            try {
                path = RCFiles.pathFromResourceLocation(new ResourceLocation(domain.toLowerCase(), ""));
                if (path == null || Files.isReadable(path)) continue;
                commandSender.func_145747_a((ITextComponent)new TextComponentString("Can't read files from mod: " + mod.getModId()));
                sane = false;
            }
            catch (RCFiles.ResourceLocationLoadException e) {
                RecurrentComplex.logger.error((Object)e);
                commandSender.func_145747_a((ITextComponent)new TextComponentString("Error reading files from mod " + mod.getModId() + ": "));
                commandSender.func_145747_a((ITextComponent)new TextComponentString(RCCommands.reason(e)));
                sane = false;
            }
            finally {
                if (path == null) continue;
                RCFiles.closeQuietly(path.getFileSystem());
            }
        }
        if (!Files.isReadable(ResourceDirectory.getServerDirectory().toPath())) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString("Can't read files from server directory"));
            sane = false;
        }
        if (!parameters.has("short")) {
            sane &= this.addStructureLog(commandSender, (s, structure) -> !structure.generationTypes(GenerationType.class).isEmpty(), "Missing generation type");
            sane &= this.addGenericStructureLog(commandSender, (s, structure) -> !structure.metadata.authors.isEmpty(), "No author");
            sane &= this.addGenericStructureLog(commandSender, (s, structure) -> structure.transformer.getTransformers().stream().allMatch(t -> t.id().length() > 0), "Transformer has empty ID");
            sane &= this.addGenerationLog(commandSender, GenerationType.class, (structure, gen) -> gen.id().length() > 0, "Generation type has empty ID");
            sane &= this.addGenerationLog(commandSender, NaturalGeneration.class, (structure, gen) -> CommandSanity.values(Biome.field_185377_q).anyMatch(b -> StructureSelector.generationWeightInBiome(gen.biomeWeights, b) > 0.0), "Natural generation type won't accept any known biomes");
            sane &= this.addGenerationLog(commandSender, NaturalGeneration.class, (structure, gen) -> CommandSanity.dimensions(server).anyMatch(d -> StructureSelector.generationWeightInDimension(gen.dimensionWeights, d.field_73011_w) > 0.0), "Natural generation type won't accept any known dimensions");
            sane &= this.addGenerationLog(commandSender, NaturalGeneration.class, (structure, gen) -> gen.getActiveGenerationWeight() > 0.0, "Natural generation type has no weight");
            sane &= this.addGenerationLog(commandSender, VanillaGeneration.class, (structure, gen) -> CommandSanity.values(Biome.field_185377_q).anyMatch(b -> gen.biomeExpression.test(b)), "Vanilla structure generation type won't accept any known biomes");
            sane &= this.addGenerationLog(commandSender, VanillaGeneration.class, (structure, gen) -> gen.getActiveWeight() > 0.0, "Vanilla structure generation type has no weight");
            sane &= this.addGenerationLog(commandSender, VanillaGeneration.class, (structure, gen) -> gen.minBaseLimit > 0.0 || gen.maxBaseLimit > 0.0 || gen.maxScaledLimit > 0.0 || gen.minScaledLimit > 0.0, "Vanilla structure is always limited to zero instances");
            sane &= this.addGenerationLog(commandSender, VanillaDecorationGeneration.class, (structure, gen) -> CommandSanity.values(Biome.field_185377_q).anyMatch(b -> StructureSelector.generationWeightInBiome(gen.biomeWeights, b) > 0.0), "Vanilla structure generation type won't accept any known biomes");
            sane &= this.addGenerationLog(commandSender, VanillaDecorationGeneration.class, (structure, gen) -> CommandSanity.dimensions(server).anyMatch(d -> StructureSelector.generationWeightInDimension(gen.dimensionWeights, d.field_73011_w) > 0.0), "Natural generation type won't accept any dimensions");
            sane &= this.addGenerationLog(commandSender, MazeGeneration.class, (structure, gen) -> gen.getWeight() > 0.0, "Maze generation type has no weight");
            sane &= this.addGenerationLog(commandSender, MazeGeneration.class, (structure, gen) -> !gen.getMazeID().trim().isEmpty(), "Maze generation type has maze id");
            sane &= this.addGenerationLog(commandSender, MazeGeneration.class, (structure, gen) -> !gen.mazeComponent.rooms.isEmpty(), "Maze generation type has no rooms");
            sane &= this.addGenerationLog(commandSender, MazeGeneration.class, (structure, gen) -> !gen.mazeComponent.exitPaths.isEmpty() || !gen.mazeComponent.defaultConnector.id.equals("Wall"), "Maze generation type has no walkable exits");
            sane &= this.addGenerationLog(commandSender, ListGeneration.class, (structure, gen) -> !gen.listID.trim().isEmpty(), "List generation has no list id");
            sane &= this.addGenerationLog(commandSender, ListGeneration.class, (structure, gen) -> gen.getWeight() > 0.0, "List generation has no weight");
            sane &= this.addGenerationLog(commandSender, SaplingGeneration.class, (structure, gen) -> gen.getActiveWeight() > 0.0, "Sapling generation has no weight");
            sane &= this.addGenerationLog(commandSender, StaticGeneration.class, (structure, gen) -> CommandSanity.dimensions(server).anyMatch(d -> gen.dimensionExpression.test(d.field_73011_w)), "Static generation won't accept any known dimensions");
        }
        if (sane && !parameters.has("silent")) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString("No problems identified!"));
        }
    }

    protected <T extends GenerationType> boolean addGenerationLog(ICommandSender commandSender, Class<T> tClass, BiPredicate<Structure<?>, T> predicate, String msg) {
        return this.addStructureLog(commandSender, (s, structure) -> structure.generationTypes(tClass).stream().allMatch(gen -> predicate.test((Structure<?>)structure, (Object)gen)), msg);
    }

    protected boolean addGenericStructureLog(ICommandSender commandSender, BiPredicate<String, GenericStructure> predicate, String msg) {
        return this.addStructureLog(commandSender, (s, structure) -> !(structure instanceof GenericStructure) || predicate.test((String)s, (GenericStructure)structure), msg);
    }

    protected boolean addStructureLog(ICommandSender commandSender, BiPredicate<String, Structure<?>> predicate, String msg) {
        PriorityQueue<String> structures = CommandSearchStructure.search(StructureRegistry.INSTANCE.activeIDs(), name -> predicate.test((String)name, (Structure<?>)StructureRegistry.INSTANCE.get((String)name)) ? 0.0 : 1.0);
        if (structures.size() > 0) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString(msg + ":"));
            CommandSearchStructure.postResultMessage("", commandSender, RCTextStyle::structure, structures);
            return false;
        }
        return true;
    }
}

