/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.structure;

import com.google.common.primitives.Doubles;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.commands.parameters.RCP;
import ivorius.reccomplex.commands.structure.StructureSearch;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameter;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.shadow.mcopts.translation.ServerTranslations;
import ivorius.reccomplex.utils.expression.BlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;

public class CommandSearchStructure
extends CommandExpecting {
    public static final int MAX_RESULTS = 20;

    public static <T> void postResultMessage(String prefix, ICommandSender sender, Function<T, ? extends ITextComponent> toComponent, Queue<T> list) {
        if (list.size() > 0) {
            boolean cut = list.size() > 20;
            TextComponentBase[] components = new TextComponentBase[cut ? 20 : list.size()];
            for (int i = 0; i < components.length; ++i) {
                components[i] = cut && i == components.length - 1 ? new TextComponentString("... (" + list.size() + ")") : toComponent.apply(list.remove());
            }
            sender.func_145747_a((ITextComponent)ServerTranslations.join("", new TextComponentString(prefix), ServerTranslations.join(components)));
        } else {
            sender.func_145747_a(RecurrentComplex.translations.get("commands.rcsearch.empty"));
        }
    }

    @Nonnull
    public static <T> PriorityQueue<T> search(Set<T> omega, ToDoubleFunction<T> rank) {
        PriorityQueue strucs = new PriorityQueue(10, (o1, o2) -> Doubles.compare((double)rank.applyAsDouble(o1), (double)rank.applyAsDouble(o2)));
        strucs.addAll(omega.stream().filter(s -> rank.applyAsDouble(s) > 0.0).collect(Collectors.toList()));
        return strucs;
    }

    public static void consider(List<ToDoubleFunction<String>> ranks, Parameter<String> parameter, Parameter.Function<Parameter<String>, ToDoubleFunction<Structure<?>>> supplier) throws CommandException {
        if (!parameter.has(1)) {
            return;
        }
        ToDoubleFunction<Structure<?>> fun = supplier.apply(parameter);
        ranks.add(name -> fun.applyAsDouble((Structure<?>)StructureRegistry.INSTANCE.get((String)name)));
    }

    public static <T> void consider(List<ToDoubleFunction<String>> ranks, Parameter<String> parameter, Function<Parameter<String>, Parameter<T>> fun, ToDoubleBiFunction<Structure<?>, T> rank) throws CommandException {
        CommandSearchStructure.consider(ranks, parameter, param -> {
            Object t = param.to(fun).require();
            return structure -> rank.applyAsDouble((Structure<?>)structure, (Object)t);
        });
    }

    public String func_71517_b() {
        return RCConfig.commandPrefix + "search";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void expect(Expect expect) {
        expect.skip().descriptionU("terms").optional().repeat().named("containing", "c").words(MCE::block).descriptionU("block expression").named("biome", "b").then(MCE::biome).descriptionU("biome id").named("dimension", "d").then(MCE::dimension).descriptionU("dimension id").named("maze", new String[0]).skip().descriptionU("maze id").named("list", new String[0]).skip().descriptionU("structure list id").named("author", new String[0]).skip().descriptionU("author").flag("all", "a");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        ArrayList<ToDoubleFunction<String>> ranks = new ArrayList<ToDoubleFunction<String>>();
        CommandSearchStructure.consider(ranks, parameters.get(0), Parameter::varargsList, (s, t) -> StructureSearch.searchRank(t, StructureSearch.keywords(StructureRegistry.INSTANCE.id(s), s)));
        CommandSearchStructure.consider(ranks, parameters.get("containing"), e -> RCP.expression(e, new BlockExpression(RecurrentComplex.specialRegistry)), StructureSearch::containedBlocks);
        CommandSearchStructure.consider(ranks, parameters.get("biome"), MCP::biome, StructureSearch::biome);
        CommandSearchStructure.consider(ranks, parameters.get("dimension"), MCP.dimension(server, sender), StructureSearch::dimension);
        CommandSearchStructure.consider(ranks, parameters.get("maze"), p -> p, StructureSearch::maze);
        CommandSearchStructure.consider(ranks, parameters.get("list"), p -> p, StructureSearch::list);
        CommandSearchStructure.consider(ranks, parameters.get("author"), p -> p, StructureSearch::author);
        boolean all = parameters.has("all");
        if (ranks.stream().noneMatch(Objects::nonNull)) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        CommandSearchStructure.postResultMessage("Results: ", sender, RCTextStyle::structure, CommandSearchStructure.search(all ? StructureRegistry.INSTANCE.ids() : StructureRegistry.INSTANCE.activeIDs(), name -> ranks.stream().filter(Objects::nonNull).mapToDouble(f -> f.applyAsDouble(name)).reduce(1.0, (a, b) -> a * b)));
    }
}

