/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.table.cell.TableCellDefault;
import ivorius.reccomplex.gui.table.cell.TableCellIntTextField;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceBlockPos
extends TableDataSourceSegmented {
    private BlockPos coord;
    private Consumer<BlockPos> consumer;
    private String title;
    private List<String> tooltip;
    protected BooleanSupplier enabled = () -> true;

    public TableDataSourceBlockPos(BlockPos coord, Consumer<BlockPos> consumer, String title) {
        this.coord = coord;
        this.consumer = consumer;
        this.title = title;
        this.addSegment(0, () -> {
            boolean enabled = this.enabled.getAsBoolean();
            TableCellIntTextField x = new TableCellIntTextField(null, this.coord.func_177958_n());
            x.setTooltip(IvTranslations.getLines("reccomplex.gui.blockpos.x"));
            x.addListener(i -> {
                this.coord = new BlockPos(i.intValue(), this.coord.func_177956_o(), this.coord.func_177952_p());
                consumer.accept(this.coord);
            });
            ((TableCellDefault)x).setEnabled(enabled);
            TableCellIntTextField y = new TableCellIntTextField(null, this.coord.func_177956_o());
            y.setTooltip(IvTranslations.getLines("reccomplex.gui.blockpos.y"));
            y.addListener(i -> {
                this.coord = new BlockPos(this.coord.func_177958_n(), i.intValue(), this.coord.func_177952_p());
                consumer.accept(this.coord);
            });
            ((TableCellDefault)y).setEnabled(enabled);
            TableCellIntTextField z = new TableCellIntTextField(null, this.coord.func_177952_p());
            z.setTooltip(IvTranslations.getLines("reccomplex.gui.blockpos.z"));
            z.addListener(i -> {
                this.coord = new BlockPos(this.coord.func_177958_n(), this.coord.func_177956_o(), i.intValue());
                consumer.accept(this.coord);
            });
            ((TableCellDefault)z).setEnabled(enabled);
            return new TitledCell(title, new TableCellMulti(x, y, z)).withTitleTooltip(this.tooltip);
        });
    }

    public TableDataSourceBlockPos(BlockPos coord, Consumer<BlockPos> consumer, String title, List<String> tooltip) {
        this(coord, consumer, title);
        this.setTooltip(tooltip);
    }

    public TableDataSourceBlockPos(BlockPos coord, Consumer<BlockPos> consumer) {
        this(coord, consumer, IvTranslations.get("reccomplex.gui.blockpos"), IvTranslations.getLines("reccomplex.gui.blockpos.tooltip"));
    }

    public List<String> getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public void setEnabled(BooleanSupplier enabled) {
        this.enabled = enabled;
    }
}

