/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.command;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.RCGuiTables;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellPresetAction;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.script.WorldScriptCommand;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceSpawnCommandEntry
extends TableDataSourceSegmented {
    private WorldScriptCommand.Entry entry;
    private TableDelegate tableDelegate;

    public TableDataSourceSpawnCommandEntry(WorldScriptCommand.Entry entry, TableDelegate tableDelegate) {
        this.entry = entry;
        this.tableDelegate = tableDelegate;
        this.addSegment(0, () -> {
            TableCellPresetAction cell = new TableCellPresetAction("default", Arrays.asList(new TableCellButton("", "spawner", Blocks.field_150474_ac.func_149732_F()), new TableCellButton("", "entity", IvTranslations.get("reccomplex.spawncommand.preset.entity"))));
            cell.addAction(action -> {
                if ("spawner".equals(action)) {
                    entry.command = "/setblock ~ ~ ~ mob_spawner 0 replace {SpawnData:{id:Zombie}}";
                } else if ("entity".equals(action)) {
                    entry.command = "/summon Zombie ~ ~ ~";
                }
                tableDelegate.reloadData();
            });
            return new TitledCell(IvTranslations.get("reccomplex.preset"), cell);
        }, () -> {
            TableCellString cell = new TableCellString("command", entry.command);
            cell.setMaxStringLength(Short.MAX_VALUE);
            cell.addListener(val -> {
                entry.command = val;
            });
            return new TitledCell(IvTranslations.get("reccomplex.gui.command"), cell);
        }, () -> RCGuiTables.defaultWeightElement(val -> {
            entry.weight = TableCells.toDouble(val);
        }, entry.weight));
    }

    @Override
    @Nonnull
    public String title() {
        return "Command";
    }
}

