/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.item;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.item.GeneratingItem;
import ivorius.reccomplex.utils.ItemHandlers;
import ivorius.reccomplex.world.storage.loot.LootGenerationHandler;
import ivorius.reccomplex.world.storage.loot.LootTable;
import ivorius.reccomplex.world.storage.loot.WeightedItemCollectionRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class ItemLootGenerationTag
extends Item
implements GeneratingItem {
    public ItemLootGenerationTag() {
        this.func_77625_d(1);
    }

    public static boolean applyGeneratorToInventory(WorldServer world, BlockPos pos, GeneratingItem generatingItem, ItemStack stack) {
        TileEntity rightClicked = world.func_175625_s(pos);
        if (ItemHandlers.hasModifiable((ICapabilityProvider)rightClicked)) {
            if (!world.field_72995_K) {
                IItemHandlerModifiable itemHandler = ItemHandlers.getModifiable((ICapabilityProvider)rightClicked);
                generatingItem.generateInInventory(world, itemHandler, world.field_73012_v, stack, world.field_73012_v.nextInt(itemHandler.getSlots()));
                LootGenerationHandler.generateAllTags(world, itemHandler, RecurrentComplex.specialRegistry.itemHidingMode(), world.field_73012_v);
            }
            return true;
        }
        return false;
    }

    public static String lootTableKey(ItemStack stack) {
        NBTTagCompound nbttagcompound;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("itemCollectionKey", 8)) {
            return stack.func_77978_p().func_74779_i("itemCollectionKey");
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("display", 10) && (nbttagcompound = stack.func_77978_p().func_74775_l("display")).func_150297_b("Name", 8)) {
            return nbttagcompound.func_74779_i("Name");
        }
        return null;
    }

    public static LootTable lootTable(ItemStack stack) {
        return (LootTable)WeightedItemCollectionRegistry.INSTANCE.get(ItemLootGenerationTag.lootTableKey(stack));
    }

    public static void setItemStackGeneratorKey(ItemStack stack, String generatorKey) {
        stack.func_77983_a("itemCollectionKey", (NBTBase)new NBTTagString(generatorKey));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            return ItemLootGenerationTag.applyGeneratorToInventory((WorldServer)worldIn, pos, this, player.func_184586_b(hand)) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            WeightedItemCollectionRegistry.INSTANCE.ids().stream().sorted().forEach(key -> {
                ItemStack stack = new ItemStack((Item)this);
                ItemLootGenerationTag.setItemStackGeneratorKey(stack, key);
                items.add((Object)stack);
            });
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String func_77653_i(ItemStack stack) {
        String key = ItemLootGenerationTag.lootTableKey(stack);
        return key != null ? key : super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        LootTable generator = ItemLootGenerationTag.lootTable(stack);
        if (generator != null) {
            tooltip.add(generator.getDescriptor());
        } else {
            tooltip.add(IvTranslations.get("inventoryGen.none"));
        }
    }
}

