/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.network;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.network.SchedulingMessageHandler;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.block.TileEntityBlockScript;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.worldscripts.TableDataSourceWorldScriptHolder;
import ivorius.reccomplex.network.PacketWorldData;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.script.WorldScriptHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketWorldDataHandler
extends SchedulingMessageHandler<PacketWorldData, IMessage> {
    public static void capture(WorldScriptHolder script, BlockPos source, BlockPos point2) {
        RecurrentComplex.network.sendToServer((IMessage)new PacketWorldData(null, source, script.origin, point2));
    }

    public static void swap(WorldScriptHolder script, BlockPos source) {
        RecurrentComplex.network.sendToServer((IMessage)new PacketWorldData(script.worldData, source, script.origin, script.origin.func_177971_a((Vec3i)BlockPositions.fromIntArray(Structures.size(script.worldData, null))).func_177982_a(-1, -1, -1)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void processClient(PacketWorldData message, MessageContext ctx) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof TableNavigator)) {
            throw new RuntimeException();
        }
        TableDataSource dataSource = ((TableNavigator)screen).currentTable().getDataSource();
        if (!(dataSource instanceof TableDataSourceWorldScriptHolder)) {
            throw new RuntimeException();
        }
        ((TableDataSourceWorldScriptHolder)dataSource).script.worldData = message.worldData;
        if (screen instanceof TableDelegate) {
            ((TableDelegate)screen).reloadData();
        }
    }

    @Override
    public void processServer(PacketWorldData message, MessageContext ctx, WorldServer world) {
        BlockPos left = message.capturePoint1.func_177971_a((Vec3i)message.source);
        BlockPos right = message.capturePoint2.func_177971_a((Vec3i)message.source);
        IvWorldData worldData = IvWorldData.capture((World)world, new BlockArea(left, right), true);
        worldData.tileEntities.removeIf(te -> TileEntity.func_190200_a((World)world, (NBTTagCompound)te) instanceof TileEntityBlockScript);
        RecurrentComplex.network.sendTo((IMessage)new PacketWorldData(worldData.createTagCompound()), ctx.getServerHandler().field_147369_b);
        if (message.worldData != null) {
            GenericStructure structure = new GenericStructure();
            structure.worldDataCompound = message.worldData;
            new StructureGenerator<GenericStructure.InstanceData>(structure).world(world).lowerCoord(left).generationPredicate(p -> !p.equals((Object)message.source)).generate();
        }
    }
}

