/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class ItemHandlers {
    public static boolean has(ICapabilityProvider provider) {
        return provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) || Arrays.stream(EnumFacing.field_82609_l).anyMatch(f -> provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f));
    }

    public static CombinedInvWrapper complete(ICapabilityProvider provider) {
        ArrayList handlers = new ArrayList();
        Arrays.stream(EnumFacing.field_82609_l).forEach(f -> {
            IItemHandler capability;
            if (provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f) && (capability = (IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f)) instanceof IItemHandlerModifiable) {
                handlers.add((IItemHandlerModifiable)capability);
            }
        });
        return new CombinedInvWrapper(handlers.toArray(new IItemHandlerModifiable[0]));
    }

    public static boolean hasModifiable(ICapabilityProvider provider, EnumFacing side) {
        return ItemHandlers.getModifiable(provider, side) != null;
    }

    public static IItemHandlerModifiable getModifiable(ICapabilityProvider provider, EnumFacing side) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return null;
        }
        IItemHandler capability = (IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        return capability instanceof IItemHandlerModifiable ? (IItemHandlerModifiable)capability : null;
    }

    public static boolean hasModifiable(ICapabilityProvider provider) {
        return ItemHandlers.hasModifiable(provider, null);
    }

    public static IItemHandlerModifiable getModifiable(ICapabilityProvider provider) {
        return ItemHandlers.getModifiable(provider, null);
    }

    public static void clear(IItemHandlerModifiable itemHandler) {
        for (int i = 0; i < itemHandler.getSlots() * 5; ++i) {
            itemHandler.setStackInSlot(Math.max(i, itemHandler.getSlots()), ItemStack.field_190927_a);
        }
    }
}

