/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature;

import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.WorldStructureGenerationData;
import ivorius.reccomplex.world.gen.feature.selector.MixingStructureSelector;
import ivorius.reccomplex.world.gen.feature.selector.NaturalStructureSelector;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.NaturalGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.StaticGeneration;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenStructures {
    public static final long POS_SEED = 1298319823120938102L;
    public static final int STRUCTURE_TRIES = 10;

    public static void planStaticStructuresInChunk(Random random, ChunkPos chunkPos, WorldServer world, BlockPos spawnPos, @Nullable Predicate<Structure> structurePredicate) {
        StaticGeneration.structuresAt(StructureRegistry.INSTANCE, chunkPos, (World)world, spawnPos).forEach(triple -> {
            StaticGeneration staticGenInfo = (StaticGeneration)triple.getMiddle();
            Structure structure = (Structure)triple.getLeft();
            BlockSurfacePos pos = (BlockSurfacePos)triple.getRight();
            if (structurePredicate != null && !structurePredicate.test(structure)) {
                return;
            }
            new StructureGenerator(structure).world(world).generationInfo(staticGenInfo).seed(random.nextLong()).randomPosition(pos, staticGenInfo.placer).fromCenter(true).partially(true, chunkPos).generate();
        });
    }

    protected static float distance(ChunkPos left, ChunkPos right) {
        return MathHelper.func_76129_c((float)((left.field_77276_a - right.field_77276_a) * (left.field_77276_a - right.field_77276_a) + (left.field_77275_b - right.field_77275_b) * (left.field_77275_b - right.field_77275_b)));
    }

    public static void planStructuresInChunk(Random random, ChunkPos chunkPos, WorldServer world, Biome biomeGen, @Nullable Predicate<Structure> structurePredicate) {
        MixingStructureSelector<NaturalGeneration, NaturalStructureSelector.Category> structureSelector = NaturalGeneration.selectors(StructureRegistry.INSTANCE).get(biomeGen, world.field_73011_w);
        float distanceToSpawn = WorldGenStructures.distance(new ChunkPos(world.func_175694_M()), chunkPos);
        List<Pair<Structure<?>, NaturalGeneration>> generated = structureSelector.generatedStructures(random, world.func_180494_b(chunkPos.func_180331_a(0, 0, 0)), world.field_73011_w, Float.valueOf(distanceToSpawn));
        generated.stream().filter(pair -> structurePredicate == null || structurePredicate.test((Structure)pair.getLeft())).forEach(pair -> WorldGenStructures.planStructureInChunk(chunkPos, world, (Structure)pair.getLeft(), (NaturalGeneration)pair.getRight(), random.nextLong()));
    }

    public static boolean generateOneStructureInChunk(Random random, ChunkPos chunkPos, WorldServer world, Biome biomeGen) {
        MixingStructureSelector<NaturalGeneration, NaturalStructureSelector.Category> structureSelector = NaturalGeneration.selectors(StructureRegistry.INSTANCE).get(biomeGen, world.field_73011_w);
        float distanceToSpawn = WorldGenStructures.distance(new ChunkPos(world.func_175694_M()), chunkPos);
        for (int i = 0; i < 10; ++i) {
            Pair<Structure<?>, NaturalGeneration> pair = structureSelector.selectOne(random, world.field_73011_w, world.func_180494_b(chunkPos.func_180331_a(0, 0, 0)), null, Float.valueOf(distanceToSpawn));
            if (pair == null || !WorldGenStructures.planStructureInChunk(chunkPos, world, (Structure)pair.getLeft(), (NaturalGeneration)pair.getRight(), random.nextLong())) continue;
            return true;
        }
        return false;
    }

    protected static boolean planStructureInChunk(ChunkPos chunkPos, WorldServer world, Structure<?> structure, NaturalGeneration naturalGenInfo, long seed) {
        String structureName = StructureRegistry.INSTANCE.id(structure);
        BlockSurfacePos genPos = WorldGenStructures.randomSurfacePos(chunkPos, seed);
        if (!naturalGenInfo.hasLimitations() || naturalGenInfo.getLimitations().areResolved((World)world, structureName)) {
            StructureGenerator<?> generator = new StructureGenerator(structure).world(world).generationInfo(naturalGenInfo).seed(seed).maturity(StructureSpawnContext.GenerateMaturity.SUGGEST).randomPosition(genPos, naturalGenInfo.placer).fromCenter(true).partially(true, chunkPos);
            if (naturalGenInfo.getGenerationWeight(world.field_73011_w, generator.environment().biome) <= 0.0) {
                RecurrentComplex.logger.trace(String.format("%s failed to spawn at %s (incompatible biome edge)", structure, genPos));
                return false;
            }
            return generator.generate() != null;
        }
        return false;
    }

    public static void complementStructuresInChunk(ChunkPos chunkPos, WorldServer world, List<WorldStructureGenerationData.StructureEntry> complement) {
        WorldStructureGenerationData data = WorldStructureGenerationData.get((World)world);
        complement.stream().filter(e -> !e.preventComplementation()).forEach(entry -> {
            Structure structure = (Structure)StructureRegistry.INSTANCE.get(entry.getStructureID());
            if (structure == null) {
                RecurrentComplex.logger.warn(String.format("Can't find structure %s (%s) to complement in %s (%d)", entry.getStructureID(), entry.getUuid(), chunkPos, world.field_73011_w.getDimension()));
                return;
            }
            if (entry.instanceData == null && !entry.firstTime) {
                RecurrentComplex.logger.warn(String.format("Can't find instance data of %s (%s) to complement in %s (%d)", entry.getStructureID(), entry.getUuid(), chunkPos, world.field_73011_w.getDimension()));
                return;
            }
            new StructureGenerator(structure).world(world).generationInfo(entry.generationInfoID).seed(WorldGenStructures.chunkSeed(entry.seed, chunkPos)).boundingBox(entry.boundingBox).transform(entry.transform).generationBB(Structures.chunkBoundingBox(chunkPos, true)).structureID(entry.getStructureID()).instanceData(entry.instanceData).maturity(StructureSpawnContext.GenerateMaturity.COMPLEMENT).generate();
            if (entry.firstTime) {
                entry.firstTime = false;
                data.func_76185_a();
            }
        });
    }

    public static long chunkSeed(long seed, ChunkPos chunkPos) {
        return (long)chunkPos.field_77276_a * 341873128712L + (long)chunkPos.field_77275_b * 132897987541L + seed;
    }

    public static BlockSurfacePos randomSurfacePos(ChunkPos chunkPos, long seed) {
        Random posRandom = new Random(seed ^ 0x12048F0015F8B476L);
        return BlockSurfacePos.from(chunkPos.func_180331_a(posRandom.nextInt(16) + 8, 0, posRandom.nextInt(16) + 8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decorate(WorldServer world, Random random, ChunkPos chunkPos, @Nullable Predicate<Structure> structurePredicate) {
        WorldStructureGenerationData data;
        boolean generated = false;
        boolean worldWantsStructures = world.func_72912_H().func_76089_r();
        WorldStructureGenerationData worldStructureGenerationData = data = WorldStructureGenerationData.get((World)world);
        synchronized (worldStructureGenerationData) {
            List<WorldStructureGenerationData.StructureEntry> complement = data.structureEntriesIn(chunkPos).collect(Collectors.toList());
            if (structurePredicate == null) {
                data.checkChunk(chunkPos);
            }
            if (structurePredicate == null) {
                WorldGenStructures.complementStructuresInChunk(chunkPos, world, complement);
            }
            if (!(RCConfig.honorStructureGenerationOption && !worldWantsStructures || structurePredicate != null && !data.checkChunkFinal(chunkPos))) {
                boolean mayGenerate;
                Biome biomeGen = world.func_180494_b(chunkPos.func_180331_a(8, 0, 8));
                BlockPos spawnPos = world.func_175694_M();
                WorldGenStructures.planStaticStructuresInChunk(random, chunkPos, world, spawnPos, structurePredicate);
                boolean bl = mayGenerate = RCConfig.isGenerationEnabled(biomeGen) && RCConfig.isGenerationEnabled(world.field_73011_w);
                if (world.field_73011_w.getDimension() == 0) {
                    double distToSpawn = IvVecMathHelper.distanceSQ(new double[]{chunkPos.field_77276_a * 16 + 8, chunkPos.field_77275_b * 16 + 8}, new double[]{spawnPos.func_177958_n(), spawnPos.func_177952_p()});
                    mayGenerate &= distToSpawn >= (double)(RCConfig.minDistToSpawnForGeneration * RCConfig.minDistToSpawnForGeneration);
                }
                if (mayGenerate) {
                    WorldGenStructures.planStructuresInChunk(random, chunkPos, world, biomeGen, structurePredicate);
                }
                generated = true;
            }
        }
        return generated;
    }
}

