/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.reccomplex.utils.RCAxisAlignedTransform;
import ivorius.reccomplex.utils.RCStructureBoundingBoxes;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.WorldSavedData;

public class WorldStructureGenerationData
extends WorldSavedData {
    private static final String IDENTIFIER = "reccomplex-structuredata";
    protected final Set<ChunkPos> checkedChunks = new HashSet<ChunkPos>();
    protected final Set<ChunkPos> checkedChunksFinal = new HashSet<ChunkPos>();
    protected final Map<UUID, Entry> entryMap = new HashMap<UUID, Entry>();
    protected final SetMultimap<ChunkPos, Entry> chunkMap = HashMultimap.create();
    protected final SetMultimap<String, StructureEntry> instanceMap = HashMultimap.create();

    public WorldStructureGenerationData(String id) {
        super(id);
    }

    public WorldStructureGenerationData() {
        this(IDENTIFIER);
    }

    public static WorldStructureGenerationData get(World world) {
        WorldStructureGenerationData data = (WorldStructureGenerationData)world.getPerWorldStorage().func_75742_a(WorldStructureGenerationData.class, IDENTIFIER);
        if (data == null) {
            data = new WorldStructureGenerationData();
            world.getPerWorldStorage().func_75745_a(data.field_76190_i, (WorldSavedData)data);
        }
        return data;
    }

    public Stream<StructureEntry> structureEntriesIn(ChunkPos coords) {
        return this.entriesAt(coords).filter(StructureEntry.class::isInstance).map(StructureEntry.class::cast);
    }

    public Stream<Entry> entriesAt(ChunkPos coords) {
        return this.chunkMap.get((Object)coords).stream();
    }

    public Stream<Entry> entriesAt(BlockPos coords) {
        return this.entriesAt(new ChunkPos(coords.func_177958_n() - 8 >> 4, coords.func_177952_p() - 8 >> 4)).filter(input -> {
            StructureBoundingBox bb = input.getBoundingBox();
            return bb != null && bb.func_175898_b((Vec3i)coords);
        });
    }

    public Stream<Entry> entriesAt(StructureBoundingBox boundingBox) {
        return RCStructureBoundingBoxes.rasterize(boundingBox, true).stream().flatMap(chunkPos -> this.entriesAt((ChunkPos)chunkPos).filter(input -> {
            StructureBoundingBox bb = input.getBoundingBox();
            return bb != null && bb.func_78884_a(boundingBox);
        }));
    }

    public Set<ChunkPos> addEntry(Entry entry) {
        this.entryMap.put(entry.getUuid(), entry);
        Set<ChunkPos> rasterized = entry.rasterize();
        for (ChunkPos coords : rasterized) {
            this.chunkMap.put((Object)coords, (Object)entry);
        }
        if (entry instanceof StructureEntry) {
            this.instanceMap.put((Object)((StructureEntry)entry).getStructureID(), (Object)((StructureEntry)entry));
        }
        this.func_76185_a();
        return Sets.intersection(this.checkedChunks, rasterized);
    }

    public Entry getEntry(UUID id) {
        return this.entryMap.get(id);
    }

    public Entry removeEntry(UUID id) {
        Entry entry = this.entryMap.remove(id);
        this.chunkMap.values().removeIf(e -> e.uuid.equals(id));
        this.instanceMap.values().removeIf(e -> e.uuid.equals(id));
        if (entry != null) {
            this.func_76185_a();
        }
        return entry;
    }

    public Set<StructureEntry> getEntriesByID(String id) {
        return this.instanceMap.get((Object)id);
    }

    public Stream<ChunkPos> checkAllChunks(Stream<ChunkPos> chunks) {
        return chunks.filter(this::checkChunk);
    }

    public boolean checkChunk(ChunkPos coords) {
        boolean added = this.checkedChunks.add(coords);
        if (added) {
            this.func_76185_a();
        }
        return added;
    }

    public boolean checkChunkFinal(ChunkPos coords) {
        boolean added = this.checkedChunksFinal.add(coords);
        if (added) {
            this.func_76185_a();
        }
        return added;
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.entryMap.clear();
        this.chunkMap.clear();
        this.instanceMap.clear();
        NBTCompoundObjects.readListFrom(compound, "entries", StructureEntry::new).forEach(this::addEntry);
        NBTCompoundObjects.readListFrom(compound, "customEntries", CustomEntry::new).forEach(this::addEntry);
        this.checkedChunks.clear();
        NBTTagLists.intArraysFrom(compound, "checkedChunks").forEach(ints -> this.checkedChunks.add(new ChunkPos(ints[0], ints[1])));
        this.checkedChunksFinal.clear();
        NBTTagLists.intArraysFrom(compound, "checkedChunksFinal").forEach(ints -> this.checkedChunksFinal.add(new ChunkPos(ints[0], ints[1])));
    }

    /*
     * Exception decompiling
     */
    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ int[] lambda$writeToNBT$65(ChunkPos c) {
        return new int[]{c.field_77276_a, c.field_77275_b};
    }

    public static class CustomEntry
    extends Entry {
        public String name;

        public CustomEntry() {
        }

        public CustomEntry(@Nonnull UUID uuid, StructureBoundingBox boundingBox, String name) {
            super(uuid, boundingBox);
            this.name = name;
        }

        @Nonnull
        public static CustomEntry from(String name, StructureBoundingBox boundingBox) {
            return new CustomEntry(UUID.randomUUID(), boundingBox, name);
        }

        @Override
        public String description() {
            return this.name;
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            super.writeToNBT(compound);
            compound.func_74778_a("name", this.name);
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.name = compound.func_74779_i("name");
        }
    }

    public static class StructureEntry
    extends Entry {
        protected String structureID;
        protected String generationInfoID;
        protected long seed;
        protected AxisAlignedTransform2D transform;
        protected NBTBase instanceData;
        protected boolean firstTime = true;
        protected boolean preventComplementation = false;

        public StructureEntry() {
        }

        public StructureEntry(@Nonnull UUID uuid, StructureBoundingBox boundingBox, String structureID, String generationInfoID, AxisAlignedTransform2D transform, boolean preventComplementation) {
            super(uuid, boundingBox);
            this.structureID = structureID;
            this.generationInfoID = generationInfoID;
            this.transform = transform;
            this.preventComplementation = preventComplementation;
        }

        @Nonnull
        public static StructureEntry complete(String structureID, String generationInfoID, StructureBoundingBox boundingBox, AxisAlignedTransform2D transform, boolean hasBeenGenerated) {
            return new StructureEntry(UUID.randomUUID(), boundingBox, structureID, generationInfoID, transform, hasBeenGenerated);
        }

        public String getStructureID() {
            return this.structureID;
        }

        public AxisAlignedTransform2D getTransform() {
            return this.transform;
        }

        public long getSeed() {
            return this.seed;
        }

        public boolean preventComplementation() {
            return this.preventComplementation;
        }

        public void setPreventComplementation(boolean preventComplementation) {
            this.preventComplementation = preventComplementation;
        }

        public NBTBase getInstanceData() {
            return this.instanceData;
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.structureID = compound.func_74779_i("structureID");
            this.generationInfoID = compound.func_150297_b(this.generationInfoID, 8) ? compound.func_74779_i("generationInfoID") : null;
            this.seed = compound.func_74764_b("seed") ? compound.func_74763_f("seed") : new Random().nextLong();
            this.transform = RCAxisAlignedTransform.read(compound, "rotation", "mirrorX");
            if (compound.func_74764_b("lowerCoord")) {
                BlockPos lowerCoord = BlockPositions.readFromNBT("lowerCoord", compound);
                Structure structure = (Structure)StructureRegistry.INSTANCE.get(this.structureID);
                StructureBoundingBox structureBoundingBox = this.boundingBox = structure != null ? Structures.boundingBox(lowerCoord, RCAxisAlignedTransform.applySize(this.transform, structure.size())) : new StructureBoundingBox();
            }
            if (compound.func_150297_b("instanceData", 10)) {
                this.instanceData = compound.func_74775_l("instanceData");
            }
            this.firstTime = compound.func_74767_n("firstTime");
            this.preventComplementation = compound.func_74767_n("preventComplementation") || compound.func_74767_n("hasBeenGenerated");
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            super.writeToNBT(compound);
            compound.func_74778_a("structureID", this.structureID);
            if (this.generationInfoID != null) {
                compound.func_74778_a("generationInfoID", this.generationInfoID);
            }
            compound.func_74772_a("seed", this.seed);
            RCAxisAlignedTransform.write(compound, this.transform, "rotation", "mirrorX");
            if (this.instanceData != null) {
                compound.func_74782_a("instanceData", this.instanceData);
            }
            compound.func_74757_a("firstTime", this.firstTime);
            compound.func_74757_a("preventComplementation", this.preventComplementation);
        }

        @Override
        public String description() {
            return this.structureID;
        }
    }

    public static abstract class Entry
    implements NBTCompoundObject {
        @Nonnull
        protected UUID uuid = UUID.randomUUID();
        protected StructureBoundingBox boundingBox = new StructureBoundingBox();
        protected boolean blocking = true;

        public Entry() {
        }

        public Entry(@Nonnull UUID uuid, StructureBoundingBox boundingBox) {
            this.uuid = uuid;
            this.boundingBox = boundingBox;
        }

        @Nonnull
        public UUID getUuid() {
            return this.uuid;
        }

        public void setUuid(@Nonnull UUID uuid) {
            this.uuid = uuid;
        }

        public StructureBoundingBox getBoundingBox() {
            return this.boundingBox;
        }

        public void setBoundingBox(StructureBoundingBox boundingBox) {
            this.boundingBox = boundingBox;
        }

        public boolean blocking() {
            return this.blocking;
        }

        public void setBlocking(boolean blocking) {
            this.blocking = blocking;
        }

        public Set<ChunkPos> rasterize() {
            return RCStructureBoundingBoxes.rasterize(this.getBoundingBox(), true);
        }

        public abstract String description();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructureEntry entry = (StructureEntry)o;
            return this.uuid.equals(entry.uuid);
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            this.uuid = new UUID(compound.func_74763_f("UUIDMS"), compound.func_74763_f("UUIDLS"));
            this.boundingBox = new StructureBoundingBox(compound.func_74759_k("boundingBox"));
            this.blocking = !compound.func_150297_b("blocking", 1) || compound.func_74767_n("blocking");
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74772_a("UUIDMS", this.uuid.getMostSignificantBits());
            compound.func_74772_a("UUIDLS", this.uuid.getLeastSignificantBits());
            compound.func_74782_a("boundingBox", (NBTBase)this.boundingBox.func_151535_h());
            compound.func_74757_a("blocking", this.blocking);
        }
    }
}

