/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.loading.FileLoaderRegistry;
import ivorius.reccomplex.files.saving.FileSaverAdapter;
import ivorius.reccomplex.json.NBTToJson;
import ivorius.reccomplex.utils.ByteArrays;
import ivorius.reccomplex.utils.zip.IvZips;
import ivorius.reccomplex.utils.zip.ZipFinder;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericVariableDomain;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class StructureSaveHandler {
    public static final StructureSaveHandler INSTANCE = new StructureSaveHandler("rcst", StructureRegistry.INSTANCE);
    public static final String STRUCTURE_INFO_JSON_FILENAME = "structure.json";
    public static final String WORLD_DATA_NBT_FILENAME = "worldData.nbt";
    public final Gson gson = this.createGson();
    public String suffix;
    public StructureRegistry registry;

    public StructureSaveHandler(String suffix, StructureRegistry registry) {
        this.suffix = suffix;
        this.registry = registry;
    }

    public Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(GenericStructure.class, (Object)new GenericStructure.Serializer());
        StructureRegistry.TRANSFORMERS.constructGson(builder);
        StructureRegistry.GENERATION_TYPES.constructGson(builder);
        builder.registerTypeAdapter(GenericVariableDomain.Variable.class, (Object)new GenericVariableDomain.Variable.Serializer());
        NBTToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    public GenericStructure fromJSON(String jsonData, NBTTagCompound worldData) throws JsonSyntaxException {
        GenericStructure structure = (GenericStructure)this.gson.fromJson(jsonData, GenericStructure.class);
        structure.worldDataCompound = worldData;
        return structure;
    }

    public String toJSON(GenericStructure structureInfo) {
        return this.gson.toJson((Object)structureInfo, GenericStructure.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GenericStructure fromResource(ResourceLocation resourceLocation) {
        try (ZipInputStream zipInputStream = new ZipInputStream(IvFileHelper.inputStreamFromResourceLocation(resourceLocation));){
            GenericStructure genericStructure = this.fromZip(zipInputStream);
            return genericStructure;
        }
        catch (Exception ex) {
            RecurrentComplex.logger.error("Could not read generic structure " + resourceLocation.toString(), (Throwable)ex);
            return null;
        }
    }

    public GenericStructure fromZip(ZipInputStream zipInputStream) throws IOException {
        ZipFinder finder = new ZipFinder();
        ZipFinder.Result<String> json = finder.bytes(STRUCTURE_INFO_JSON_FILENAME, String::new);
        ZipFinder.Result<NBTTagCompound> worldData = finder.bytes(WORLD_DATA_NBT_FILENAME, bytes -> CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream((byte[])bytes)));
        try {
            finder.read(zipInputStream);
            return this.fromJSON(json.get(), worldData.get());
        }
        catch (ZipFinder.MissingEntryException | IOException e) {
            throw new IOException("Error loading structure", e);
        }
    }

    public void toZip(Structure<?> structure, ZipOutputStream zipOutputStream) throws IOException {
        GenericStructure copy = structure.copyAsGenericStructure();
        Objects.requireNonNull(copy);
        IvZips.addZipEntry(zipOutputStream, STRUCTURE_INFO_JSON_FILENAME, this.toJSON(copy).getBytes());
        IvZips.addZipEntry(zipOutputStream, WORLD_DATA_NBT_FILENAME, ByteArrays.toByteArray(s -> CompressedStreamTools.func_74799_a((NBTTagCompound)copy.worldDataCompound, (OutputStream)s)));
        zipOutputStream.close();
    }

    public class Saver
    extends FileSaverAdapter<Structure<?>> {
        public Saver(String id) {
            super(id, StructureSaveHandler.this.suffix, StructureSaveHandler.this.registry);
        }

        @Override
        public void saveFile(Path path, Structure<?> structure) throws Exception {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                StructureSaveHandler.this.toZip(structure, zipOutputStream);
            }
        }
    }

    public class Loader
    extends FileLoaderRegistry<GenericStructure> {
        public Loader() {
            super(StructureSaveHandler.this.suffix, StructureSaveHandler.this.registry);
        }

        @Override
        public GenericStructure read(Path path, String name) throws Exception {
            try (ZipInputStream zip2 = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));){
                GenericStructure genericStructure = StructureSaveHandler.this.fromZip(zip2);
                return genericStructure;
            }
        }
    }
}

