/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.generation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.client.rendering.MazeVisualizationContext;
import ivorius.reccomplex.files.SimpleLeveledRegistry;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceVanillaDecorationGeneration;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.presets.PresettedList;
import ivorius.reccomplex.utils.presets.PresettedObjects;
import ivorius.reccomplex.world.gen.feature.decoration.RCBiomeDecorator;
import ivorius.reccomplex.world.gen.feature.selector.CachedStructureSelectors;
import ivorius.reccomplex.world.gen.feature.selector.EnvironmentalSelection;
import ivorius.reccomplex.world.gen.feature.selector.StructureSelector;
import ivorius.reccomplex.world.gen.feature.structure.Placer;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.WeightedBiomeMatcher;
import ivorius.reccomplex.world.gen.feature.structure.generic.WeightedDimensionMatcher;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.SelectivePlacer;
import ivorius.reccomplex.world.gen.feature.structure.generic.presets.BiomeMatcherPresets;
import ivorius.reccomplex.world.gen.feature.structure.generic.presets.DimensionMatcherPresets;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VanillaDecorationGeneration
extends GenerationType
implements EnvironmentalSelection<RCBiomeDecorator.DecorationType> {
    private static Gson gson = VanillaDecorationGeneration.createGson();
    public Double generationWeight;
    public final PresettedList<WeightedBiomeMatcher> biomeWeights = new PresettedList<WeightedBiomeMatcher>(BiomeMatcherPresets.instance(), null);
    public final PresettedList<WeightedDimensionMatcher> dimensionWeights = new PresettedList<WeightedDimensionMatcher>(DimensionMatcherPresets.instance(), null);
    public RCBiomeDecorator.DecorationType type;
    public BlockPos spawnShift;
    public SelectivePlacer placer;

    public VanillaDecorationGeneration() {
        this(null, null, RCBiomeDecorator.DecorationType.TREE, BlockPos.field_177992_a);
        this.biomeWeights.setPreset("overworld");
        this.dimensionWeights.setPreset("overworld");
        this.placer = new SelectivePlacer();
    }

    public VanillaDecorationGeneration(@Nullable String id, Double generationWeight, RCBiomeDecorator.DecorationType type, BlockPos spawnShift) {
        super(id != null ? id : VanillaDecorationGeneration.randomID(VanillaDecorationGeneration.class));
        this.type = type;
        this.generationWeight = generationWeight;
        this.spawnShift = spawnShift;
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(VanillaDecorationGeneration.class, (Object)new Serializer());
        builder.registerTypeAdapter(WeightedBiomeMatcher.class, (Object)new WeightedBiomeMatcher.Serializer());
        builder.registerTypeAdapter(WeightedDimensionMatcher.class, (Object)new WeightedDimensionMatcher.Serializer());
        return builder.create();
    }

    public static Gson getGson() {
        return gson;
    }

    public static CachedStructureSelectors<StructureSelector<VanillaDecorationGeneration, RCBiomeDecorator.DecorationType>> selectors(StructureRegistry registry) {
        return registry.module(Cache.class).selectors;
    }

    @Override
    @Nonnull
    public String id() {
        return this.id;
    }

    @Override
    public void setID(@Nonnull String id) {
        this.id = id;
    }

    public void setSpawnShift(BlockPos spawnShift) {
        this.spawnShift = spawnShift;
    }

    @Override
    public String displayString() {
        return IvTranslations.get("reccomplex.generationInfo.decoration.title");
    }

    @Override
    @Nullable
    public Placer placer() {
        return this.placer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(MazeVisualizationContext mazeVisualizationContext, TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceVanillaDecorationGeneration(navigator, delegate, this);
    }

    public double getActiveGenerationWeight() {
        return this.generationWeight != null ? this.generationWeight : 1.0;
    }

    @Override
    public double getGenerationWeight(WorldProvider provider, Biome biome) {
        return this.getActiveGenerationWeight() * StructureSelector.generationWeight(provider, biome, this.biomeWeights, this.dimensionWeights);
    }

    @Override
    public RCBiomeDecorator.DecorationType generationCategory() {
        return this.type;
    }

    public static class Cache
    extends SimpleLeveledRegistry.Module<StructureRegistry> {
        protected CachedStructureSelectors<StructureSelector<VanillaDecorationGeneration, RCBiomeDecorator.DecorationType>> selectors;

        @Override
        public void setRegistry(StructureRegistry registry) {
            this.selectors = new CachedStructureSelectors<StructureSelector>((biome, worldProvider) -> new StructureSelector(registry.activeMap(), (WorldProvider)worldProvider, (Biome)biome, VanillaDecorationGeneration.class));
        }

        @Override
        public void invalidate() {
            this.selectors.clear();
        }
    }

    public static class Serializer
    implements JsonSerializer<VanillaDecorationGeneration>,
    JsonDeserializer<VanillaDecorationGeneration> {
        public VanillaDecorationGeneration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "vanillaStructureSpawnInfo");
            String id = GenerationType.readID(jsonObject);
            Double spawnWeight = jsonObject.has("generationWeight") ? Double.valueOf(JsonUtils.getDouble(jsonObject, "generationWeight")) : null;
            RCBiomeDecorator.DecorationType type = (RCBiomeDecorator.DecorationType)((Object)context.deserialize(jsonObject.get("type"), RCBiomeDecorator.DecorationType.class));
            int spawnX = JsonUtils.getInt(jsonObject, "spawnShiftX", 0);
            int spawnY = JsonUtils.getInt(jsonObject, "spawnShiftY", 0);
            int spawnZ = JsonUtils.getInt(jsonObject, "spawnShiftZ", 0);
            VanillaDecorationGeneration genInfo = new VanillaDecorationGeneration(id, spawnWeight, type, new BlockPos(spawnX, spawnY, spawnZ));
            PresettedObjects.read(jsonObject, gson, genInfo.biomeWeights, "biomeWeightsPreset", "generationBiomes", new TypeToken<ArrayList<WeightedBiomeMatcher>>(){}.getType());
            PresettedObjects.read(jsonObject, gson, genInfo.dimensionWeights, "dimensionWeightsPreset", "generationDimensions", new TypeToken<ArrayList<WeightedDimensionMatcher>>(){}.getType());
            genInfo.placer = JsonUtils.has(jsonObject, "placer") ? (SelectivePlacer)SelectivePlacer.gson.fromJson((JsonElement)JsonUtils.getJsonObject(jsonObject, "placer"), SelectivePlacer.class) : SelectivePlacer.surfacePlacer(0);
            return genInfo;
        }

        public JsonElement serialize(VanillaDecorationGeneration src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.id);
            if (src.generationWeight != null) {
                jsonObject.addProperty("generationWeight", (Number)src.generationWeight);
            }
            jsonObject.add("type", context.serialize((Object)src.type));
            jsonObject.addProperty("spawnShiftX", (Number)src.spawnShift.func_177958_n());
            jsonObject.addProperty("spawnShiftY", (Number)src.spawnShift.func_177956_o());
            jsonObject.addProperty("spawnShiftZ", (Number)src.spawnShift.func_177952_p());
            PresettedObjects.write(jsonObject, gson, src.biomeWeights, "biomeWeightsPreset", "generationBiomes");
            PresettedObjects.write(jsonObject, gson, src.dimensionWeights, "dimensionWeightsPreset", "generationDimensions");
            jsonObject.add("placer", SelectivePlacer.gson.toJsonTree((Object)src.placer));
            return jsonObject;
        }
    }
}

