/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.placement.rays;

import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.IvGsonHelper;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.world.WorldCache;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSupplied;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.FactorLimit;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.StructurePlaceContext;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RayDynamicMove
extends FactorLimit.Ray {
    public Type type;
    public boolean up;

    public RayDynamicMove() {
        this(null, Type.STRUCTURE_HEIGHT);
    }

    public RayDynamicMove(Float weight, Type type) {
        super(weight);
        this.type = type;
    }

    @Override
    public OptionalInt cast(WorldCache cache, StructurePlaceContext context, IvBlockCollection collection, Set<BlockPos> surface, int y) {
        int mod = this.up ? 1 : -1;
        switch (this.type) {
            case STRUCTURE_HEIGHT: {
                return OptionalInt.of(y + StructureBoundingBoxes.size(context.boundingBox)[1] * mod);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String displayString() {
        return IvTranslations.format("reccomplex.placer.factors.limit.rays.dynmove.title." + (this.up ? "up" : "down"), IvTranslations.get("reccomplex.placer.factors.limit.rays.dynmove.type." + IvGsonHelper.serializedName(this.type)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceSegmented(this.rayTableDataSource(navigator, delegate), new TableDataSourceSupplied(() -> {
            TableCellEnum<Type> cell = new TableCellEnum<Type>(null, this.type, TableCellEnum.options((Enum[])Type.values(), (String)"reccomplex.placer.factors.limit.rays.dynmove.type.", (boolean)true));
            cell.addListener(v -> {
                this.type = v;
            });
            return new TitledCell(IvTranslations.get("reccomplex.placer.factors.limit.rays.dynmove.type"), cell);
        }, () -> {
            TableCellBoolean cell = new TableCellBoolean(null, this.up, IvTranslations.get("reccomplex.direction.up"), IvTranslations.get("reccomplex.direction.down"));
            cell.addListener(v -> {
                this.up = v;
            });
            return new TitledCell(IvTranslations.get("reccomplex.placer.factors.limit.rays.matcher.direction"), cell);
        }));
    }

    public static enum Type {
        STRUCTURE_HEIGHT;

    }
}

