/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTMulti;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.utils.expression.EnvironmentExpression;
import ivorius.reccomplex.utils.presets.PresettedObject;
import ivorius.reccomplex.utils.presets.PresettedObjects;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLiveContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.presets.TransfomerPresets;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TransformerMulti
extends Transformer<InstanceData> {
    public static Gson gson = TransformerMulti.createGson();
    protected final PresettedObject<Data> data = new PresettedObject<Data>(TransfomerPresets.instance(), null);

    public TransformerMulti() {
        this(null, "");
    }

    public TransformerMulti(@Nullable String id, String expression) {
        this(id, expression, Collections.emptyList());
    }

    public TransformerMulti(@Nullable String id, String expression, Collection<Transformer> transformers) {
        super(id != null ? id : TransformerMulti.randomID(TransformerMulti.class));
        this.data.setContents(new Data());
        this.data.getContents().environmentExpression.setExpression(expression);
        this.data.getContents().transformers.addAll(transformers);
    }

    private static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Data.class, (Object)new DataSerializer());
        StructureRegistry.TRANSFORMERS.constructGson(builder);
        return builder.create();
    }

    public static TransformerMulti fromPreset(String preset) {
        TransformerMulti transformer = new TransformerMulti();
        transformer.setID("preset_" + preset);
        transformer.data.setPreset(preset);
        return transformer;
    }

    public static TransformerMulti fuse(List<TransformerMulti> transformers) {
        TransformerMulti transformer = new TransformerMulti();
        transformers.forEach(t -> transformer.getTransformers().add((Transformer)t));
        return transformer;
    }

    public boolean isEmpty(InstanceData instanceData) {
        return instanceData.pairedTransformers.isEmpty();
    }

    public InstanceData fuseDatas(List<InstanceData> instanceDatas) {
        List<Transformer> transformers = this.getTransformers();
        InstanceData instanceData = new InstanceData();
        for (int i = 0; i < instanceDatas.size(); ++i) {
            instanceData.pairedTransformers.add((Pair<Transformer, NBTStorable>)Pair.of((Object)transformers.get(i), (Object)instanceDatas.get(i)));
        }
        return instanceData;
    }

    public List<Transformer> getTransformers() {
        return this.data.getContents().transformers;
    }

    public EnvironmentExpression getEnvironmentMatcher() {
        return this.data.getContents().environmentExpression;
    }

    public PresettedObject<Data> getData() {
        return this.data;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayString() {
        if (this.data.getPreset() != null) {
            return this.data.getPresetRegistry().metadata(this.data.getPreset()).map(m -> TextFormatting.GREEN + m.title).orElse(TextFormatting.GOLD + this.data.getPreset());
        }
        int amount = this.getTransformers().size();
        return amount == 0 ? IvTranslations.get("reccomplex.transformer.multi.none") : IvTranslations.format("reccomplex.transformer.multi.multiple", amount);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTMulti(this, navigator, delegate);
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, IvWorldData worldData) {
        InstanceData instanceData = new InstanceData();
        boolean bl = instanceData.deactivated = !this.getEnvironmentMatcher().test(context.environment);
        if (!instanceData.deactivated) {
            this.getTransformers().forEach(t -> instanceData.pairedTransformers.add((Pair<Transformer, NBTStorable>)Pair.of((Object)t, t.prepareInstanceData(context, worldData))));
        }
        return instanceData;
    }

    @Override
    public void configureInstanceData(InstanceData instanceData, StructurePrepareContext context, IvWorldData worldData, RunTransformer transformer) {
        if (!instanceData.deactivated) {
            instanceData.pairedTransformers.forEach(pair -> ((Transformer)pair.getLeft()).configureInstanceData((NBTStorable)pair.getRight(), context, worldData, transformer));
        }
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        InstanceData instanceData = new InstanceData();
        instanceData.readFromNBT(context, nbt, this.getTransformers());
        return instanceData;
    }

    @Override
    public boolean mayGenerate(InstanceData instanceData, StructurePrepareContext context, IvWorldData worldData) {
        return instanceData.deactivated || instanceData.pairedTransformers.stream().allMatch(input -> ((Transformer)input.getLeft()).mayGenerate((NBTStorable)input.getRight(), context, worldData));
    }

    @Override
    public boolean skipGeneration(InstanceData instanceData, StructureLiveContext context, BlockPos pos, IBlockState state, IvWorldData worldData, BlockPos sourcePos) {
        return !instanceData.deactivated && instanceData.pairedTransformers.stream().anyMatch(input -> ((Transformer)input.getLeft()).skipGeneration((NBTStorable)input.getRight(), context, pos, state, worldData, sourcePos));
    }

    @Override
    public void transform(InstanceData instanceData, Transformer.Phase phase, StructureSpawnContext context, IvWorldData worldData, RunTransformer transformer) {
        if (!instanceData.deactivated) {
            instanceData.pairedTransformers.forEach(pair -> ((Transformer)pair.getLeft()).transform((NBTStorable)pair.getRight(), phase, context, worldData, transformer));
        }
    }

    public static class Serializer
    implements JsonDeserializer<TransformerMulti>,
    JsonSerializer<TransformerMulti> {
        public TransformerMulti deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "transformerMulti");
            TransformerMulti transformer = new TransformerMulti();
            transformer.setID(Transformer.readID(jsonObject));
            if (!PresettedObjects.read(jsonObject, gson, transformer.data, "dataPreset", "data", Data.class) && jsonObject.has("environmentMatcher") && jsonObject.has("transformers")) {
                transformer.getData().setContents((Data)gson.fromJson((JsonElement)jsonObject, Data.class));
            }
            return transformer;
        }

        public JsonElement serialize(TransformerMulti src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.id());
            PresettedObjects.write(jsonObject, gson, src.data, "dataPreset", "data");
            return jsonObject;
        }
    }

    public static class DataSerializer
    implements JsonDeserializer<Data>,
    JsonSerializer<Data> {
        public Data deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "transformerMultiData");
            Data data = new Data();
            data.environmentExpression.setExpression(JsonUtils.getString(jsonObject, "environmentMatcher", ""));
            Transformer.idRandomizers.push(new Random(-559038737L));
            Transformer[] transformers = (Transformer[])gson.fromJson(jsonObject.get("transformers"), Transformer[].class);
            if (transformers != null) {
                Collections.addAll(data.transformers, transformers);
            }
            Transformer.idRandomizers.pop();
            return data;
        }

        public JsonElement serialize(Data src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("environmentMatcher", src.environmentExpression.getExpression());
            jsonObject.add("transformers", gson.toJsonTree(src.transformers));
            return jsonObject;
        }
    }

    public static class Data {
        public final List<Transformer> transformers = new ArrayList<Transformer>();
        public final EnvironmentExpression environmentExpression = new EnvironmentExpression();
    }

    public static class InstanceData
    implements NBTStorable {
        public static final String KEY_TRANSFORMERS = "transformers";
        public final List<Pair<Transformer, NBTStorable>> pairedTransformers = new ArrayList<Pair<Transformer, NBTStorable>>();
        public boolean deactivated;

        public void readFromNBT(StructureLoadContext context, NBTBase nbt, List<Transformer> transformers) {
            NBTTagCompound compound = nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound();
            NBTTagLists.compoundsFrom(compound, KEY_TRANSFORMERS).forEach(transformerCompound -> {
                String transformerID = transformerCompound.func_74779_i("id");
                transformers.stream().filter(t -> t.id().equals(transformerID)).findAny().ifPresent(transformer -> this.pairedTransformers.add((Pair<Transformer, NBTStorable>)Pair.of((Object)transformer, transformer.loadInstanceData(context, transformerCompound.func_74781_a("data")))));
            });
            this.deactivated = compound.func_74767_n("deactivated");
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagLists.writeTo(compound, KEY_TRANSFORMERS, this.pairedTransformers.stream().map(pair -> {
                NBTTagCompound transformerCompound = new NBTTagCompound();
                transformerCompound.func_74782_a("data", ((NBTStorable)pair.getRight()).writeToNBT());
                transformerCompound.func_74778_a("id", ((Transformer)pair.getLeft()).id());
                return transformerCompound;
            }).collect(Collectors.toList()));
            compound.func_74757_a("deactivated", this.deactivated);
            return compound;
        }
    }
}

