/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import ivorius.ivtoolkit.blocks.BlockStates;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTReplace;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.nbt.NBTNone;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.BlockExpression;
import ivorius.reccomplex.utils.presets.PresettedList;
import ivorius.reccomplex.utils.presets.PresettedObjects;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.WeightedBlockState;
import ivorius.reccomplex.world.gen.feature.structure.generic.presets.WeightedBlockStatePresets;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerSingleBlock;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TransformerReplace
extends TransformerSingleBlock<NBTNone> {
    public final PresettedList<WeightedBlockState> destination = new PresettedList<WeightedBlockState>(WeightedBlockStatePresets.instance(), null);
    public BlockExpression sourceMatcher;

    public TransformerReplace() {
        this(null, BlockExpression.of(RecurrentComplex.specialRegistry, Blocks.field_150325_L));
        this.destination.setPreset("air");
    }

    public TransformerReplace(@Nullable String id, String sourceExpression) {
        super(id != null ? id : TransformerReplace.randomID(TransformerReplace.class));
        this.sourceMatcher = ExpressionCache.of(new BlockExpression(RecurrentComplex.specialRegistry), sourceExpression);
    }

    public static void setBlock(StructureSpawnContext context, int[] areaSize, BlockPos pos, WeightedBlockState entry, Supplier<NBTTagCompound> tileEntity) {
        if (entry.state != null) {
            GenericStructure.setBlock(context, areaSize, pos, entry.state, tileEntity);
        }
    }

    public TransformerReplace replaceWith(WeightedBlockState ... states) {
        this.destination.setContents((Collection<WeightedBlockState>)Arrays.asList(states));
        return this;
    }

    @Override
    public boolean matches(Environment environment, NBTNone instanceData, IBlockState state) {
        return this.sourceMatcher.test(state);
    }

    @Override
    public void transformBlock(NBTNone instanceData, Transformer.Phase phase, StructureSpawnContext context, RunTransformer transformer, int[] areaSize, BlockPos coord, IBlockState sourceState) {
        WeightedBlockState blockState = ((ArrayList)this.destination.getContents()).size() > 0 ? (WeightedBlockState)WeightedSelector.selectItem(context.random, (Collection)this.destination.getContents()) : new WeightedBlockState(null, null, null);
        TransformerReplace.setBlock(context, areaSize, coord, blockState, () -> blockState.tileEntityInfo);
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context, IvWorldData worldData) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayString() {
        return "Replace: " + this.sourceMatcher.getDisplayString(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTReplace(this, navigator, delegate);
    }

    @Override
    public boolean generatesInPhase(NBTNone instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    public static class Serializer
    implements JsonDeserializer<TransformerReplace>,
    JsonSerializer<TransformerReplace> {
        private MCRegistry registry;
        private Gson gson;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
            this.gson = new GsonBuilder().registerTypeAdapter(WeightedBlockState.class, (Object)new WeightedBlockState.Serializer(registry)).create();
        }

        public static String readLegacyMatcher(JsonObject jsonObject, String blockKey, String metadataKey) {
            if (jsonObject.has(blockKey)) {
                String sourceBlock = JsonUtils.getString(jsonObject, blockKey);
                int sourceMeta = JsonUtils.getInt(jsonObject, metadataKey, -1);
                return sourceMeta >= 0 ? String.format("%s & %s%d", sourceBlock, "metadata=", sourceMeta) : sourceBlock;
            }
            return null;
        }

        public TransformerReplace deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.asJsonObject(jsonElement, "transformerReplace");
            String id = Transformer.readID(jsonObject);
            String expression = Serializer.readLegacyMatcher(jsonObject, "source", "sourceMetadata");
            if (expression == null) {
                expression = JsonUtils.getString(jsonObject, "sourceExpression", "");
            }
            TransformerReplace transformer = new TransformerReplace(id, expression);
            PresettedObjects.read(jsonObject, this.gson, transformer.destination, "destinationPreset", "destination", new TypeToken<ArrayList<WeightedBlockState>>(){}.getType());
            if (jsonObject.has("dest")) {
                Block dest = this.registry.blockFromID(new ResourceLocation(JsonUtils.getString(jsonObject, "dest")));
                byte[] destMeta = (byte[])context.deserialize(jsonObject.get("destMetadata"), byte[].class);
                transformer.destination.setToCustom();
                for (byte b : destMeta) {
                    ((ArrayList)transformer.destination.getContents()).add(new WeightedBlockState(null, BlockStates.fromMetadata(dest, b), null));
                }
            }
            return transformer;
        }

        public JsonElement serialize(TransformerReplace transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", transformer.id());
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            PresettedObjects.write(jsonObject, this.gson, transformer.destination, "destinationPreset", "destination");
            return jsonObject;
        }
    }
}

