/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.storage.loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import io.netty.buffer.ByteBuf;
import ivorius.reccomplex.json.NBTToJson;
import ivorius.reccomplex.world.storage.loot.GenericLootTable;
import ivorius.reccomplex.world.storage.loot.InventoryLoadException;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ItemCollectionSaveHandler {
    public static final ItemCollectionSaveHandler INSTANCE = new ItemCollectionSaveHandler();
    private Gson gson = this.createGson();

    public Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(GenericLootTable.Component.class, (Object)new GenericLootTable.Component.Serializer());
        NBTToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    public void write(ByteBuf data, GenericLootTable.Component component) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.toJSON(component));
    }

    @Nullable
    public GenericLootTable.Component read(ByteBuf data) {
        try {
            return this.fromJSON(ByteBufUtils.readUTF8String((ByteBuf)data));
        }
        catch (InventoryLoadException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toJSON(GenericLootTable.Component component) {
        return this.gson.toJson((Object)component, GenericLootTable.Component.class);
    }

    public GenericLootTable.Component fromJSON(String json) throws InventoryLoadException {
        try {
            return (GenericLootTable.Component)((Object)this.gson.fromJson(json, GenericLootTable.Component.class));
        }
        catch (JsonSyntaxException e) {
            throw new InventoryLoadException(e);
        }
    }
}

