/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.additionalstructures.world;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.BiomeDictionary;
import xxrexraptorxx.additionalstructures.util.DebugHelper;

public class StructureGenerator
extends WorldGenerator {
    private String structureName;

    public StructureGenerator(String structureName) {
        this.structureName = structureName;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        WorldServer worldServer = (WorldServer)world;
        MinecraftServer minecraftServer = world.func_73046_m();
        TemplateManager templateManager = worldServer.func_184163_y();
        Template template = templateManager.func_189942_b(minecraftServer, new ResourceLocation("additionalstructures", this.structureName));
        int variation = 3;
        if (template == null) {
            System.err.println("The structure: " + this.structureName + " did not exist!");
            return false;
        }
        variation = this.structureName.endsWith("_") ? 8 : (this.structureName.startsWith("underground_") || this.structureName.startsWith("flying_") || world.field_73011_w.getDimension() == -1 ? 200 : 3);
        if (StructureGenerator.canSpawnHere(template, (World)worldServer, position, variation)) {
            Rotation rotation = Rotation.values()[rand.nextInt(3)];
            PlacementSettings settings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(StructureGenerator.getRotation()).func_186226_b(false);
            template.func_186253_b(world, position, settings);
            Map dataBlocks = template.func_186258_a(position, settings);
            for (Map.Entry entry : dataBlocks.entrySet()) {
                try {
                    String[] data = ((String)entry.getValue()).split(" ");
                    if (data.length < 2) continue;
                    Block block = Block.func_149684_b((String)data[0]);
                    IBlockState state = null;
                    state = data.length == 3 ? block.func_176203_a(Integer.parseInt(data[2])) : block.func_176223_P();
                    for (Map.Entry entry2 : block.func_176223_P().func_177228_b().entrySet()) {
                        if (!((IProperty)entry2.getKey()).func_177699_b().equals(EnumFacing.class) || !((IProperty)entry2.getKey()).func_177701_a().equals("facing")) continue;
                        state = state.func_185907_a(rotation.func_185830_a(Rotation.CLOCKWISE_180));
                        break;
                    }
                    world.func_180501_a((BlockPos)entry.getKey(), state, 3);
                    TileEntity te = world.func_175625_s((BlockPos)entry.getKey());
                    if (te == null || !(te instanceof TileEntityLockableLoot)) continue;
                    ((TileEntityLockableLoot)te).func_189404_a(new ResourceLocation(data[1]), rand.nextLong());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (position.func_177956_o() > 0) {
                DebugHelper.Logger("Structure (" + this.structureName + ") generated at: " + position.func_177958_n() + " " + position.func_177956_o() + " " + position.func_177952_p());
            } else {
                DebugHelper.ErrorLogger("Spawning of structure (" + this.structureName + ") failed.");
            }
            if (!this.structureName.startsWith("underground_") || world.field_73011_w.getDimension() != DimensionType.NETHER.func_186068_a()) {
                int searchRange = 10;
                int posX = position.func_177958_n();
                int posY = position.func_177956_o() - 1;
                int posZ = position.func_177952_p();
                for (int x = 0; x < template.func_186259_a().func_177958_n(); ++x) {
                    for (int z = 0; z < template.func_186259_a().func_177952_p(); ++z) {
                        for (int y = 0; y < 10; ++y) {
                            if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != Blocks.field_150350_a && world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != Blocks.field_150329_H && world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != Blocks.field_150398_cm && world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != Blocks.field_150330_I) continue;
                            if (BiomeDictionary.hasType((Biome)world.func_180494_b(position), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                                world.func_175656_a(new BlockPos(posX, posY, posZ), Blocks.field_150354_m.func_176223_P());
                            } else if (BiomeDictionary.hasType((Biome)world.func_180494_b(position), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                                world.func_175656_a(new BlockPos(posX, posY, posZ), Blocks.field_150350_a.func_176223_P());
                            } else if (BiomeDictionary.hasType((Biome)world.func_180494_b(position), (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
                                world.func_175656_a(new BlockPos(posX, posY, posZ), Blocks.field_150377_bs.func_176223_P());
                            } else {
                                world.func_175656_a(new BlockPos(posX, posY, posZ), Blocks.field_150346_d.func_176223_P());
                            }
                            if (position.func_177956_o() > 0) {
                                DebugHelper.Logger("Foundation for " + this.structureName + " generated at: " + posX + " " + posY + " " + posZ + ", with rotation: " + settings.func_186215_c());
                            }
                            --posY;
                        }
                        posY = position.func_177956_o() - 1;
                        if (settings.func_186215_c() == Rotation.NONE) {
                            ++posZ;
                            continue;
                        }
                        if (settings.func_186215_c() == Rotation.CLOCKWISE_180) {
                            --posZ;
                            continue;
                        }
                        if (settings.func_186215_c() == Rotation.CLOCKWISE_90) {
                            ++posZ;
                            continue;
                        }
                        if (settings.func_186215_c() != Rotation.COUNTERCLOCKWISE_90) continue;
                        --posZ;
                    }
                    posZ = position.func_177952_p();
                    if (settings.func_186215_c() == Rotation.NONE) {
                        ++posX;
                        continue;
                    }
                    if (settings.func_186215_c() == Rotation.CLOCKWISE_180) {
                        --posX;
                        continue;
                    }
                    if (settings.func_186215_c() == Rotation.CLOCKWISE_90) {
                        --posX;
                        continue;
                    }
                    if (settings.func_186215_c() != Rotation.COUNTERCLOCKWISE_90) continue;
                    ++posX;
                }
                posX = position.func_177958_n();
            }
            return true;
        }
        DebugHelper.ErrorLogger("Not accepted position for (" + this.structureName + ") at: " + position.func_177958_n() + " " + position.func_177956_o() + " " + position.func_177952_p());
        return false;
    }

    public static boolean canSpawnHere(Template template, World world, BlockPos pos, int variation) {
        return StructureGenerator.isCornerValid(world, pos, variation) && StructureGenerator.isCornerValid(world, pos.func_177982_a(template.func_186259_a().func_177958_n(), 0, 0), variation) && StructureGenerator.isCornerValid(world, pos.func_177982_a(template.func_186259_a().func_177958_n(), 0, template.func_186259_a().func_177952_p()), variation) && StructureGenerator.isCornerValid(world, pos.func_177982_a(0, 0, template.func_186259_a().func_177952_p()), variation);
    }

    public static boolean isCornerValid(World world, BlockPos pos, int variation) {
        int groundY = StructureGenerator.getGroundFromAbove(world, pos.func_177958_n(), pos.func_177952_p());
        return groundY > pos.func_177956_o() - variation && groundY < pos.func_177956_o() + variation;
    }

    public static int getGroundFromAbove(World world, int x, int z) {
        int y = -99;
        if (world.field_73011_w.getDimension() != DimensionType.NETHER.func_186068_a()) {
            y = world.func_72940_L();
            boolean foundGround = false;
            while (!foundGround && y-- > 0) {
                Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                foundGround = block != Blocks.field_150350_a && block != Blocks.field_150329_H && block != Blocks.field_150431_aC && block != Blocks.field_150362_t && block != Blocks.field_150361_u && block != Blocks.field_150364_r && block != Blocks.field_150363_s && block != Blocks.field_150328_O && block != Blocks.field_150327_N && block != Blocks.field_150434_aF && block != Blocks.field_150392_bi && block != Blocks.field_150398_cm;
            }
        }
        BlockPos pos = new BlockPos(x, y - 1, z);
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && !BiomeDictionary.hasType((Biome)world.func_180494_b(pos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            y = -99;
        }
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l || world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || world.func_180495_p(pos).func_177230_c() == Blocks.field_150432_aD || world.func_180495_p(pos).func_177230_c() == Blocks.field_150403_cj) {
            y = -99;
        }
        return y;
    }

    public static Rotation getRotation() {
        Random random = new Random();
        if (random.nextInt(2) == 1) {
            return Rotation.CLOCKWISE_180;
        }
        return Rotation.NONE;
    }
}

