/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows;

import bl4ckscor3.mod.scarecrows.entity.EntityScarecrow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ScarecrowTracker {
    private static final Map<Integer, Collection<Integer>> trackedScarecrows = new HashMap<Integer, Collection<Integer>>();

    public static void track(EntityScarecrow entity) {
        ScarecrowTracker.getTrackedScarecrows(entity.func_130014_f_()).add(entity.func_145782_y());
    }

    public static void stopTracking(EntityScarecrow entity) {
        ScarecrowTracker.getTrackedScarecrows(entity.func_130014_f_()).remove(entity.func_145782_y());
    }

    public static List<EntityScarecrow> getScarecrowsInRange(World world, BlockPos pos) {
        Collection<Integer> scarecrows = ScarecrowTracker.getTrackedScarecrows(world);
        ArrayList<EntityScarecrow> returnValue = new ArrayList<EntityScarecrow>();
        Iterator<Integer> it = scarecrows.iterator();
        while (it.hasNext()) {
            int scarecrowId = it.next();
            Entity scarecrow = world.func_73045_a(scarecrowId);
            if (scarecrow instanceof EntityScarecrow) {
                if (!ScarecrowTracker.canScarecrowReach((EntityScarecrow)scarecrow, pos)) continue;
                returnValue.add((EntityScarecrow)scarecrow);
                continue;
            }
            it.remove();
        }
        return returnValue;
    }

    private static Collection<Integer> getTrackedScarecrows(World world) {
        Collection<Integer> scarecrows = trackedScarecrows.get(world.field_73011_w.getDimension());
        if (scarecrows == null) {
            scarecrows = new HashSet<Integer>();
            trackedScarecrows.put(world.field_73011_w.getDimension(), scarecrows);
        }
        return scarecrows;
    }

    private static boolean canScarecrowReach(EntityScarecrow entity, BlockPos pos) {
        AxisAlignedBB scarecrowRange = entity.getArea();
        return scarecrowRange.field_72340_a <= (double)pos.func_177958_n() && scarecrowRange.field_72338_b <= (double)pos.func_177956_o() && scarecrowRange.field_72339_c <= (double)pos.func_177952_p() && scarecrowRange.field_72336_d >= (double)pos.func_177958_n() && scarecrowRange.field_72337_e >= (double)pos.func_177956_o() && scarecrowRange.field_72334_f >= (double)pos.func_177952_p();
    }
}

