/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows;

import bl4ckscor3.mod.scarecrows.block.BlockArm;
import bl4ckscor3.mod.scarecrows.block.BlockInvisibleLight;
import bl4ckscor3.mod.scarecrows.entity.EntityScarecrow;
import bl4ckscor3.mod.scarecrows.proxy.ServerProxy;
import bl4ckscor3.mod.scarecrows.util.CustomDataSerializers;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="scarecrows", name="Scarecrows", version="v1.0.8", acceptedMinecraftVersions="1.12")
@Mod.EventBusSubscriber
public class Scarecrows {
    public static final String MODID = "scarecrows";
    public static final String NAME = "Scarecrows";
    public static final String VERSION = "v1.0.8";
    public static final String MC_VERSION = "1.12";
    public static final String PREFIX = "scarecrows:";
    @SidedProxy(clientSide="bl4ckscor3.mod.scarecrows.proxy.ClientProxy", serverSide="bl4ckscor3.mod.scarecrows.proxy.ServerProxy")
    public static ServerProxy proxy;
    @GameRegistry.ObjectHolder(value="scarecrows:arm")
    public static final Block ARM;
    @GameRegistry.ObjectHolder(value="scarecrows:invisible_light")
    public static final Block INVISIBLE_LIGHT;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata modMeta = event.getModMetadata();
        modMeta.authorList = Arrays.asList("bl4ckscor3");
        modMeta.autogenerated = false;
        modMeta.description = "Adds scarecrows that keep monsters (and animals if you want) off your lawn.";
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        DataSerializers.func_187189_a(CustomDataSerializers.AXISALIGNEDBB);
        DataSerializers.func_187189_a(CustomDataSerializers.SCARECROWTYPE);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BlockArm());
        event.getRegistry().register((IForgeRegistryEntry)new BlockInvisibleLight());
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation(MODID, "scarecrow"), 0).entity(EntityScarecrow.class).name("scarecrows:scarecrow").tracker(256, 20, false).build());
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        ARM = null;
        INVISIBLE_LIGHT = null;
    }
}

