/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems;

import com.mojang.brigadier.CommandDispatcher;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.silentchaos512.gems.IProxy;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.chaos.ChaosSourceCapability;
import net.silentchaos512.gems.client.gui.DebugOverlay;
import net.silentchaos512.gems.command.ChaosCommand;
import net.silentchaos512.gems.command.HungryCommand;
import net.silentchaos512.gems.command.SoulCommand;
import net.silentchaos512.gems.compat.gear.SGearProxy;
import net.silentchaos512.gems.compat.gear.SGearStatHandler;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.event.TraitEvents;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.GemsContainers;
import net.silentchaos512.gems.init.GemsEffects;
import net.silentchaos512.gems.init.GemsEnchantments;
import net.silentchaos512.gems.init.GemsEntities;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.init.GemsLoot;
import net.silentchaos512.gems.init.GemsRecipeInit;
import net.silentchaos512.gems.init.GemsSounds;
import net.silentchaos512.gems.init.GemsTileEntities;
import net.silentchaos512.gems.init.GemsTraits;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.TeleporterLinkerItem;
import net.silentchaos512.gems.lib.ColorHandlers;
import net.silentchaos512.gems.lib.chaosbuff.ChaosBuffManager;
import net.silentchaos512.gems.lib.fun.AprilFools;
import net.silentchaos512.gems.lib.soul.GearSoulPart;
import net.silentchaos512.gems.lib.soul.Soul;
import net.silentchaos512.gems.lib.urn.UpgradePlanter;
import net.silentchaos512.gems.network.Network;
import net.silentchaos512.gems.util.SoulEvents;
import net.silentchaos512.gems.world.GemsWorldFeatures;
import net.silentchaos512.gems.world.feature.structure.ShrineTest;
import net.silentchaos512.lib.util.LibHooks;

class SideProxy
implements IProxy {
    private MinecraftServer server = null;

    SideProxy() {
        SilentGems.LOGGER.debug("Gems SideProxy init");
        SGearProxy.detectSilentGear();
        if (SGearProxy.isLoaded()) {
            SilentGems.LOGGER.info("Register part type {}", (Object)GearSoulPart.TYPE);
            GemsTraits.registerSerializers();
            MinecraftForge.EVENT_BUS.register((Object)SoulEvents.INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)TraitEvents.INSTANCE);
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcEnqueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcProcess);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, GemsBlocks::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, GemsContainers::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Enchantment.class, GemsEnchantments::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, GemsEntities::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, GemsItems::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Effect.class, GemsEffects::registerEffects);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Potion.class, GemsEffects::registerPotions);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, GemsSounds::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, GemsTileEntities::registerAll);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.register((Object)Soul.Events.INSTANCE);
        GemsLoot.init();
        GemsRecipeInit.init();
        GemsConfig.init();
        Network.init();
        if (SilentGems.isDevBuild()) {
            SilentGems.LOGGER.info("Silent's Gems (version {}) detected as a dev build. If this is not a development environment, this is a bug!", (Object)SilentGems.getVersion());
            ShrineTest.init();
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        SilentGems.LOGGER.debug("Gems commonSetup");
        ChaosSourceCapability.register();
        UpgradePlanter.init();
        LibHooks.registerCompostable((float)0.3f, (IItemProvider)GemsItems.fluffyPuffSeeds);
        LibHooks.registerCompostable((float)0.5f, (IItemProvider)CraftingItems.FLUFFY_PUFF);
        if (SGearProxy.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new SGearStatHandler());
        }
        DeferredWorkQueue.runLater(GemsWorldFeatures::addFeaturesToBiomes);
    }

    private void imcEnqueue(InterModEnqueueEvent event) {
        SilentGems.LOGGER.debug("Gems imcEnqueue");
    }

    private void imcProcess(InterModProcessEvent event) {
        SilentGems.LOGGER.debug("Gems imcProcess");
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        this.server = event.getServer();
        IReloadableResourceManager resourceManager = event.getServer().func_195570_aG();
        resourceManager.func_219534_a((IFutureReloadListener)ChaosBuffManager.INSTANCE);
        CommandDispatcher dispatcher = event.getServer().func_195571_aL().func_197054_a();
        ChaosCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        SoulCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        if (SilentGems.isDevBuild()) {
            HungryCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        }
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    static class Server
    extends SideProxy {
        Server() {
            SilentGems.LOGGER.debug("Gems SideProxy.Server init");
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        }

        private void serverSetup(FMLDedicatedServerSetupEvent event) {
            SilentGems.LOGGER.debug("Gems serverSetup");
        }
    }

    static class Client
    extends SideProxy {
        Client() {
            SilentGems.LOGGER.debug("Gems SideProxy.Client init");
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ColorHandlers::onBlockColors);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ColorHandlers::onItemColors);
            MinecraftForge.EVENT_BUS.addListener(TeleporterLinkerItem::renderGameOverlay);
            if (SGearProxy.isLoaded()) {
                MinecraftForge.EVENT_BUS.register((Object)SoulEvents.Client.INSTANCE);
            }
            if (SilentGems.isDevBuild()) {
                MinecraftForge.EVENT_BUS.register((Object)new DebugOverlay());
            }
            if (AprilFools.isRightDay()) {
                SilentGems.LOGGER.info("Registered April Fools Day events");
                MinecraftForge.EVENT_BUS.register((Object)AprilFools.INSTANCE);
            }
        }

        private void clientSetup(FMLClientSetupEvent event) {
            SilentGems.LOGGER.debug("Gems clientSetup");
            GemsEntities.registerRenderers(event);
            GemsTileEntities.registerRenderers(event);
            GemsContainers.registerScreens(event);
        }

        @Override
        @Nullable
        public PlayerEntity getClientPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }
    }
}

