/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;

public final class Skulls {
    private static final Map<Class<? extends LivingEntity>, SkullInfo> map = new HashMap<Class<? extends LivingEntity>, SkullInfo>();
    private static final List<SkullInfo> mobSkulls = new ArrayList<SkullInfo>();
    private static final List<SkullInfo> playerSkulls = new ArrayList<SkullInfo>();

    private Skulls() {
    }

    public static ItemStack getPlayerSkull(PlayerEntity player) {
        return Skulls.getPlayerSkull(player.func_200200_C_().func_150254_d());
    }

    public static ItemStack getPlayerSkull(String playerName) {
        ItemStack skull = new ItemStack((IItemProvider)Items.field_196184_dx);
        CompoundNBT tags = skull.func_196082_o();
        tags.func_74778_a("SkullOwner", playerName);
        return skull;
    }

    public static ItemStack getSkull(LivingEntity entity) {
        return Skulls.getSkull(entity.getClass());
    }

    public static ItemStack getSkull(Class<? extends LivingEntity> entityClass) {
        SkullInfo skullInfo = map.get(entityClass);
        if (skullInfo == null) {
            return ItemStack.field_190927_a;
        }
        return skullInfo.stack.get();
    }

    public static ItemStack selectRandom(Random random) {
        return Skulls.selectRandom(random, 0.25f);
    }

    public static ItemStack selectRandom(Random random, float playerChance) {
        if (random.nextFloat() < playerChance) {
            int index = random.nextInt(playerSkulls.size());
            return Skulls.playerSkulls.get((int)index).stack.get();
        }
        int index = random.nextInt(mobSkulls.size());
        return Skulls.mobSkulls.get((int)index).stack.get();
    }

    public static float getDropRate(LivingEntity entity) {
        return Skulls.getDropRate(entity.getClass());
    }

    public static float getDropRate(Class<? extends LivingEntity> entityClass) {
        SkullInfo skullInfo = map.get(entityClass);
        return skullInfo != null ? skullInfo.dropRate : 0.0f;
    }

    public static void put(Class<? extends LivingEntity> entityClass, Supplier<ItemStack> skull, float dropRate) {
        SkullInfo info = new SkullInfo();
        info.stack = skull;
        info.dropRate = dropRate;
        map.put(entityClass, info);
        mobSkulls.add(info);
    }

    public static void putPlayer(String playerName) {
        SkullInfo info = new SkullInfo();
        info.stack = () -> Skulls.getPlayerSkull(playerName);
        playerSkulls.add(info);
    }

    static {
        Skulls.put(SkeletonEntity.class, () -> new ItemStack((IItemProvider)Items.field_196182_dv), 0.1f);
        Skulls.put(WitherSkeletonEntity.class, () -> new ItemStack((IItemProvider)Items.field_196183_dw), 0.1f);
        Skulls.put(ZombieEntity.class, () -> new ItemStack((IItemProvider)Items.field_196186_dz), 0.1f);
        Skulls.put(PlayerEntity.class, () -> new ItemStack((IItemProvider)Items.field_196184_dx), 0.5f);
        Skulls.put(CreeperEntity.class, () -> new ItemStack((IItemProvider)Items.field_196185_dy), 0.05f);
        Skulls.putPlayer("SilentChaos512");
        Skulls.putPlayer("ChaoticPlayz");
        Skulls.putPlayer("M4thG33k");
        Skulls.putPlayer("notch");
        Skulls.putPlayer("MHF_Alex");
        Skulls.putPlayer("MHF_Blaze");
        Skulls.putPlayer("MHF_CaveSpider");
        Skulls.putPlayer("MHF_Chicken");
        Skulls.putPlayer("MHF_Cow");
        Skulls.putPlayer("MHF_Enderman");
        Skulls.putPlayer("MHF_Ghast");
        Skulls.putPlayer("MHF_Golem");
        Skulls.putPlayer("MHF_Herobrine");
        Skulls.putPlayer("MHF_LavaSlime");
        Skulls.putPlayer("MHF_MushroomCow");
        Skulls.putPlayer("MHF_Ocelot");
        Skulls.putPlayer("MHF_Pig");
        Skulls.putPlayer("MHF_PigZombie");
        Skulls.putPlayer("MHF_Sheep");
        Skulls.putPlayer("MHF_Slime");
        Skulls.putPlayer("MHF_Spider");
        Skulls.putPlayer("MHF_Squid");
        Skulls.putPlayer("MHF_Steve");
        Skulls.putPlayer("MHF_Villager");
    }

    static class SkullInfo {
        Supplier<ItemStack> stack;
        float dropRate;

        SkullInfo() {
        }
    }
}

