/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.chaos;

import java.util.Locale;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum ChaosEmissionRate {
    NONE(0),
    MINIMAL(8),
    SMALL(64),
    MODERATE(512),
    HIGH(4096),
    VERY_HIGH(32768),
    EXTREME(262144);

    private final int maxValue;

    private ChaosEmissionRate(int maxValue) {
        this.maxValue = maxValue;
    }

    public static ChaosEmissionRate fromAmount(int amount) {
        for (ChaosEmissionRate e : ChaosEmissionRate.values()) {
            if (e.maxValue < amount) continue;
            return e;
        }
        return EXTREME;
    }

    public ITextComponent getDisplayName() {
        String name = this.name().toLowerCase(Locale.ROOT);
        return new TranslationTextComponent("chaos.silentgems.emissionRate." + name, new Object[0]);
    }

    public ITextComponent getDisplayName(int chaos) {
        if (this == NONE || this == MINIMAL) {
            return this.getDisplayName();
        }
        ChaosEmissionRate previous = ChaosEmissionRate.values()[this.ordinal() - 1];
        int diff = this.maxValue - previous.maxValue;
        if (chaos > previous.maxValue + 2 * diff / 3) {
            TranslationTextComponent text = new TranslationTextComponent("chaos.silentgems.emissionRate.plus2", new Object[0]);
            return this.getDisplayName().func_150257_a((ITextComponent)text);
        }
        if (chaos > previous.maxValue + diff / 3) {
            TranslationTextComponent text = new TranslationTextComponent("chaos.silentgems.emissionRate.plus1", new Object[0]);
            return this.getDisplayName().func_150257_a((ITextComponent)text);
        }
        return this.getDisplayName();
    }

    public ITextComponent getEmissionText() {
        return new TranslationTextComponent("chaos.silentgems.emission", new Object[]{this.getDisplayName()});
    }

    public ITextComponent getEmissionText(int chaos) {
        return new TranslationTextComponent("chaos.silentgems.emission", new Object[]{this.getDisplayName(chaos)});
    }
}

