/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.chaos;

import java.util.function.BiFunction;
import net.minecraft.entity.player.PlayerEntity;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.utils.MathUtils;

public class ChaosEvent {
    private final float chance;
    private final int cooldownTime;
    private final int minChaos;
    private final int maxChaos;
    private final int chaosDissipated;
    private final BiFunction<PlayerEntity, Integer, Boolean> action;

    public ChaosEvent(float chance, int cooldownTimeInSeconds, int minChaos, int maxChaos, int chaosDissipated, BiFunction<PlayerEntity, Integer, Boolean> action) {
        this.chance = chance;
        this.cooldownTime = cooldownTimeInSeconds;
        this.minChaos = minChaos;
        this.maxChaos = maxChaos;
        this.chaosDissipated = chaosDissipated;
        this.action = action;
    }

    public boolean tryActivate(PlayerEntity entity, int chaos) {
        if (chaos > this.minChaos && ChaosEvent.tryChance(this.chance, chaos, this.maxChaos)) {
            return this.activate(entity, chaos);
        }
        return false;
    }

    public boolean activate(PlayerEntity entity, int chaos) {
        if (this.action.apply(entity, chaos).booleanValue()) {
            Chaos.dissipate(entity, this.chaosDissipated);
            return true;
        }
        return false;
    }

    private static boolean tryChance(float max, int chaos, int maxChaos) {
        float chance = Math.min(max * (float)chaos / (float)maxChaos, max);
        return MathUtils.tryPercentage((double)chance);
    }

    public int getCooldownTime() {
        return this.cooldownTime;
    }
}

