/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.Locale;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.tags.Tag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.GemsTags;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.utils.Lazy;
import net.silentchaos512.utils.MathUtils;

public enum CorruptedBlocks implements IBlockProvider
{
    STONE(Blocks.field_150348_b, GemsTags.Blocks.CORRUPTABLE_STONE),
    DIRT(Blocks.field_150346_d, GemsTags.Blocks.CORRUPTABLE_DIRT);

    private final Lazy<Block> block;
    private final Lazy<Item> pile;
    private final Block purifyBlock;
    private final Predicate<Block> canReplace;

    private CorruptedBlocks(Block purifyBlock, Tag<Block> replaces) {
        this.purifyBlock = purifyBlock;
        this.block = Lazy.of(() -> new CorruptedBlock());
        this.pile = Lazy.of(() -> new Item(new Item.Properties().func_200916_a(GemsItemGroups.MATERIALS)));
        this.canReplace = block -> block.func_203417_a(replaces);
    }

    public Block asBlock() {
        return (Block)this.block.get();
    }

    public Item func_199767_j() {
        return this.asBlock().func_199767_j();
    }

    public Item getPile() {
        return (Item)this.pile.get();
    }

    public Block getPurifyBlock() {
        return this.purifyBlock;
    }

    public String getName() {
        return "corrupted_" + this.name().toLowerCase(Locale.ROOT);
    }

    public boolean canReplace(Block block) {
        return this.canReplace.test(block);
    }

    private class CorruptedBlock
    extends Block {
        CorruptedBlock() {
            super(Block.Properties.func_200945_a((Material)Material.field_151571_B).func_200943_b(1.0f).func_200947_a(SoundType.field_185849_b).func_200951_a(7).func_200944_c());
        }

        public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
            if (MathUtils.tryPercentage((Random)random, (double)0.01)) {
                worldIn.func_180501_a(pos, CorruptedBlocks.this.purifyBlock.func_176223_P(), 3);
            }
        }
    }
}

