/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class FluffyBlock
extends Block {
    private static final Map<DyeColor, FluffyBlock> MAP = new EnumMap<DyeColor, FluffyBlock>(DyeColor.class);
    private final DyeColor color;

    private FluffyBlock(DyeColor color) {
        super(Block.Properties.func_200945_a((Material)Material.field_151580_n).func_200948_a(0.8f, 3.0f).func_200947_a(SoundType.field_185854_g));
        this.color = color;
    }

    public static FluffyBlock get(DyeColor color) {
        if (!MAP.containsKey(color)) {
            FluffyBlock block = new FluffyBlock(color);
            MAP.put(color, block);
        }
        return MAP.get(color);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        if (distance < 2.0f || world.field_72995_K) {
            return;
        }
        int stackedBlocks = 0;
        while (world.func_180495_p(pos).func_177230_c() == this) {
            pos = pos.func_177977_b();
            ++stackedBlocks;
        }
        distance -= Math.min((float)(10 * stackedBlocks), distance);
        entity.field_70143_R = 0.0f;
        entity.func_180430_e(distance, 1.0f);
    }

    private static void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack mainHand = event.getEntityPlayer().func_184586_b(Hand.MAIN_HAND);
        if (!mainHand.func_190926_b() && mainHand.func_77973_b() instanceof ShearsItem) {
            int efficiency = EnchantmentHelper.func_185293_e((LivingEntity)event.getEntityPlayer());
            float speed = event.getNewSpeed() * 4.0f;
            if (efficiency > 0) {
                speed += (float)(efficiency * efficiency + 1);
            }
            event.setNewSpeed(speed);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(FluffyBlock::onGetBreakSpeed);
    }
}

