/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.gems.lib.Gems;

public class GemLampBlock
extends Block {
    private final Gems gem;
    private final State lampState;

    public GemLampBlock(Gems gem, State lampState) {
        super(Block.Properties.func_200945_a((Material)Material.field_151591_t).func_200948_a(0.3f, 15.0f).func_200951_a(lampState.lit ? 15 : 0));
        this.gem = gem;
        this.lampState = lampState;
    }

    public static String nameFor(Gems gem, State lampState) {
        return gem.func_176610_l() + "_lamp" + lampState.suffix;
    }

    private void checkAndUpdateState(World world, BlockPos pos) {
        boolean powered;
        State newLampState;
        if (!world.field_72995_K && (newLampState = this.lampState.withPower(powered = world.func_175640_z(pos))) != this.lampState) {
            BlockState newState = this.gem.getLamp(newLampState).func_176223_P();
            world.func_180501_a(pos, newState, 2);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean p_220082_5_) {
        this.checkAndUpdateState(worldIn, pos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        this.checkAndUpdateState(worldIn, pos);
    }

    public void func_196267_b(BlockState state, World world, BlockPos pos, Random random) {
        this.checkAndUpdateState(world, pos);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.lampState.hasItem()) {
            super.func_149666_a(group, items);
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(this.gem.getSet().getDisplayName());
        if (flag.func_194127_a()) {
            tooltip.add((ITextComponent)new StringTextComponent("Type: " + (Object)((Object)this.lampState)));
        }
    }

    public ITextComponent func_200291_n() {
        String translationKey = "block.silentgems.gem_lamp" + (this.lampState.inverted ? "_inverted" : "");
        return new TranslationTextComponent(translationKey, new Object[]{this.gem.getDisplayName()});
    }

    public static enum State {
        UNLIT(false, false, ""),
        LIT(true, false, "_lit"),
        INVERTED_LIT(true, true, "_inverted_lit"),
        INVERTED_UNLIT(false, true, "_inverted");

        private final boolean lit;
        private final boolean inverted;
        private final String suffix;

        private State(boolean lit, boolean inverted, String suffix) {
            this.lit = lit;
            this.inverted = inverted;
            this.suffix = suffix;
        }

        public boolean lit() {
            return this.lit;
        }

        public boolean inverted() {
            return this.inverted;
        }

        public boolean hasItem() {
            return this.lit == this.inverted;
        }

        public State withPower(boolean powered) {
            if (this.inverted) {
                return powered ? INVERTED_UNLIT : INVERTED_LIT;
            }
            return powered ? LIT : UNLIT;
        }
    }
}

