/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.altar;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import net.silentchaos512.gems.block.altar.AltarContainer;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.crafting.altar.AltarRecipe;
import net.silentchaos512.gems.crafting.altar.AltarRecipeManager;
import net.silentchaos512.gems.init.GemsTileEntities;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;

public class AltarTileEntity
extends LockableSidedInventoryTileEntity
implements ITickableTileEntity {
    private static final int INVENTORY_SIZE = 3;
    @SyncVariable(name="Progress")
    private int progress;
    @SyncVariable(name="ProcessTime")
    private int processTime;
    @SyncVariable(name="ChaosGenerated")
    private int chaosGenerated;
    private int chaosBuffer;

    public AltarTileEntity() {
        super(GemsTileEntities.TRANSMUTATION_ALTAR.type(), 3);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        AltarRecipe recipe = this.getMatchingRecipe();
        if (recipe != null && this.hasRoomInOutput(recipe)) {
            ++this.progress;
            this.chaosGenerated = recipe.getChaosGenerated();
            this.chaosBuffer += this.chaosGenerated;
            this.processTime = recipe.getProcessTime();
            if (this.progress >= this.processTime) {
                this.placeResultInOutput(recipe);
                this.consumeIngredients(recipe);
                this.progress = 0;
            }
            this.sendUpdate();
        } else {
            this.setNeutralState();
        }
        if (this.chaosBuffer > 0 && this.field_145850_b.func_82737_E() % 20L == 0L) {
            Chaos.generate((ICapabilityProvider)this.field_145850_b, this.chaosBuffer, this.field_174879_c);
            this.chaosBuffer = 0;
        }
    }

    private void sendUpdate() {
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private void setNeutralState() {
        boolean update = false;
        if (this.progress > 0) {
            this.progress = 0;
            update = true;
        }
        if (this.chaosGenerated > 0) {
            this.chaosGenerated = 0;
            update = true;
        }
        if (update) {
            this.sendUpdate();
        }
    }

    @Nullable
    private AltarRecipe getMatchingRecipe() {
        if (this.func_70301_a(0).func_190926_b()) {
            return null;
        }
        return AltarRecipeManager.getMatch((IInventory)this);
    }

    private boolean hasRoomInOutput(AltarRecipe recipe) {
        ItemStack output = this.func_70301_a(2);
        return output.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)recipe.getResult());
    }

    private void consumeIngredients(AltarRecipe recipe) {
        this.func_70298_a(0, 1);
        ItemStack catalyst = recipe.consumeCatalyst(this.func_70301_a(1));
        this.func_70299_a(1, catalyst);
    }

    private void placeResultInOutput(AltarRecipe recipe) {
        ItemStack output = this.func_70301_a(2);
        ItemStack result = recipe.getResult();
        if (output.func_190926_b()) {
            this.func_70299_a(2, result.func_77946_l());
        } else {
            output.func_190920_e(output.func_190916_E() + result.func_190916_E());
        }
    }

    public int[] func_180463_a(Direction side) {
        switch (side) {
            case UP: {
                return new int[]{0, 1};
            }
            case DOWN: {
                return new int[]{0, 1, 2};
            }
        }
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index != 2;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 2;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.silentgems.transmutation_altar", new Object[0]);
    }

    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return new AltarContainer(p_213906_1_, p_213906_2_, this);
    }

    public void func_145839_a(CompoundNBT tags) {
        super.func_145839_a(tags);
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundNBT)tags);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.WRITE);
        return tags;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        return tags;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundNBT)packet.func_148857_g());
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getChaosGenerated() {
        return this.chaosGenerated;
    }
}

