/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.flowerpot;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.LightType;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.GlowroseBlock;
import net.silentchaos512.gems.block.flowerpot.PhantomLightBlock;
import net.silentchaos512.gems.block.flowerpot.PhantomLightTileEntity;
import net.silentchaos512.gems.init.GemsTileEntities;
import net.silentchaos512.lib.util.TimeUtils;

public class LuminousFlowerPotTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int TRY_LIGHT_DELAY = TimeUtils.ticksFromSeconds((float)5.0f);
    private static final int TE_SEARCH_RADIUS = 7;
    private static final String NBT_FLOWER = "PottedFlowerItem";
    private int ticksExisted = 0;
    private ItemStack flower = ItemStack.field_190927_a;
    private boolean plantedGlowrose = false;

    public LuminousFlowerPotTileEntity() {
        super(GemsTileEntities.CHAOS_FLOWER_POT.type());
    }

    public void func_73660_a() {
        int delay;
        if (this.ticksExisted == 0) {
            this.ticksExisted += SilentGems.random.nextInt(300);
        }
        int n = delay = this.ticksExisted < 600 ? 10 : TRY_LIGHT_DELAY;
        if (++this.ticksExisted % delay == 0) {
            this.tryPlacePhantomLight();
        }
    }

    private void tryPlacePhantomLight() {
        if (this.field_145850_b.field_72995_K || this.flower.func_190926_b()) {
            return;
        }
        Random rand = SilentGems.random;
        boolean longRange = rand.nextFloat() < 0.5f;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        int dist = 8 + (longRange ? 6 : 0);
        int k = longRange ? 8 : 4;
        int angleFactor = rand.nextInt(2 * k);
        Vec3d vec = new Vec3d((double)dist, 0.0, 0.0);
        vec = vec.func_178785_b((float)angleFactor / (float)k * (float)Math.PI);
        BlockPos.MutableBlockPos tryPos = new BlockPos.MutableBlockPos(x = (int)((long)x + Math.round(vec.field_72450_a)), y += 2, z = (int)((long)z + Math.round(vec.field_72449_c)));
        if (this.canPlacePhantomLightAt((BlockPos)tryPos)) {
            this.placePhantomLightAt((BlockPos)tryPos);
            return;
        }
        for (int ty = y + 1; ty > y - 2; --ty) {
            for (int tx = x - 1; tx < x + 2; ++tx) {
                for (int tz = z - 1; tz < z + 2; ++tz) {
                    tryPos.func_181079_c(tx, ty, tz);
                    if (!this.canPlacePhantomLightAt((BlockPos)tryPos)) continue;
                    this.placePhantomLightAt((BlockPos)tryPos);
                    return;
                }
            }
        }
    }

    private boolean canPlacePhantomLightAt(BlockPos target) {
        TileEntity te;
        BlockPos pos;
        int i;
        if (!this.field_145850_b.func_175623_d(target) || this.field_145850_b.func_175642_b(LightType.BLOCK, target) > 9) {
            return false;
        }
        Class<?> clazz = null;
        for (i = 0; i < 7 && clazz == null; ++i) {
            pos = target.func_177981_b(i);
            te = this.field_145850_b.func_175625_s(pos);
            if (te != null) {
                clazz = te.getClass();
                continue;
            }
            if (this.field_145850_b.func_175623_d(pos)) continue;
            return true;
        }
        for (i = 0; i < 7; ++i) {
            pos = target.func_177979_c(i);
            te = this.field_145850_b.func_175625_s(pos);
            if (te != null && clazz == te.getClass()) {
                return false;
            }
            if (this.field_145850_b.func_175623_d(pos)) continue;
            return true;
        }
        return true;
    }

    private void placePhantomLightAt(BlockPos target) {
        this.field_145850_b.func_175656_a(target, LuminousFlowerPotTileEntity.getLightBlock());
        TileEntity tile = this.field_145850_b.func_175625_s(target);
        if (tile instanceof PhantomLightTileEntity) {
            PhantomLightTileEntity tileLight = (PhantomLightTileEntity)tile;
            tileLight.setSpawnerPos(this.field_174879_c);
        }
    }

    private static BlockState getLightBlock() {
        return ((PhantomLightBlock)((Object)PhantomLightBlock.INSTANCE.get())).func_176223_P();
    }

    @Deprecated
    public int getFlowerId() {
        Block flowerBlock = Block.func_149634_a((Item)this.flower.func_77973_b());
        if (!this.flower.func_190926_b() && flowerBlock instanceof GlowroseBlock) {
            return ((GlowroseBlock)flowerBlock).getGem().ordinal();
        }
        return -1;
    }

    ItemStack getFlower() {
        return this.flower;
    }

    void setFlower(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        this.flower = stack;
        this.plantedGlowrose = Block.func_149634_a((Item)stack.func_77973_b()) instanceof GlowroseBlock;
        this.ticksExisted = 0;
    }

    public void func_145839_a(CompoundNBT tags) {
        if (tags.func_74764_b(NBT_FLOWER)) {
            this.flower = ItemStack.func_199557_a((CompoundNBT)tags.func_74775_l(NBT_FLOWER));
        }
        super.func_145839_a(tags);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        if (!this.flower.func_190926_b()) {
            tags.func_218657_a(NBT_FLOWER, (INBT)this.flower.serializeNBT());
        }
        return super.func_189515_b(tags);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        if (!this.flower.func_190926_b()) {
            tags.func_218657_a(NBT_FLOWER, (INBT)new ItemStack((IItemProvider)this.flower.func_77973_b()).serializeNBT());
        }
        return tags;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (pkt.func_148857_g().func_74764_b(NBT_FLOWER)) {
            this.flower = ItemStack.func_199557_a((CompoundNBT)pkt.func_148857_g().func_74775_l(NBT_FLOWER));
        }
        super.onDataPacket(net, pkt);
    }
}

