/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.flowerpot;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.silentchaos512.gems.block.flowerpot.LuminousFlowerPotTileEntity;
import net.silentchaos512.gems.init.GemsTileEntities;
import net.silentchaos512.lib.util.TimeUtils;

public class PhantomLightTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int SPAWNER_CHECK_FREQUENCY = TimeUtils.ticksFromSeconds((float)60.0f);
    private BlockPos spawnerPos = null;
    private boolean playerPlaced = false;
    private int ticksExisted = 0;

    public PhantomLightTileEntity() {
        super(GemsTileEntities.PHANTOM_LIGHT.type());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ++this.ticksExisted % SPAWNER_CHECK_FREQUENCY == 0 && this.shouldRemove()) {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    private boolean shouldRemove() {
        if (this.playerPlaced) {
            return false;
        }
        if (this.spawnerPos == null) {
            return true;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.spawnerPos);
        return tile == null || !(tile instanceof LuminousFlowerPotTileEntity);
    }

    void setSpawnerPos(BlockPos pos) {
        this.spawnerPos = pos;
    }

    public void setPlacedByPlayer(boolean value) {
        this.playerPlaced = value;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.spawnerPos = new BlockPos(compound.func_74762_e("spawnerX"), compound.func_74762_e("spawnerY"), compound.func_74762_e("spawnerZ"));
        this.playerPlaced = compound.func_74767_n("placedByPlayer");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("spawnerX", this.spawnerPos != null ? this.spawnerPos.func_177958_n() : 0);
        compound.func_74768_a("spawnerY", this.spawnerPos != null ? this.spawnerPos.func_177956_o() : 0);
        compound.func_74768_a("spawnerZ", this.spawnerPos != null ? this.spawnerPos.func_177952_p() : 0);
        compound.func_74757_a("placedByPlayer", this.playerPlaced);
        return compound;
    }
}

