/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.supercharger;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.supercharger.SuperchargerContainer;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.compat.gear.SGearProxy;
import net.silentchaos512.gems.init.GemsEnchantments;
import net.silentchaos512.gems.init.GemsTags;
import net.silentchaos512.gems.init.GemsTileEntities;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.MathUtils;

public class SuperchargerTileEntity
extends LockableSidedInventoryTileEntity
implements ITickableTileEntity {
    private static final int INVENTORY_SIZE = 3;
    private static final int UPDATE_FREQUENCY = TimeUtils.ticksFromSeconds((float)15.0f);
    @SyncVariable(name="Progress")
    private int progress;
    @SyncVariable(name="ProcessTime")
    private int processTime;
    @SyncVariable(name="StructureLevel")
    private int structureLevel;
    @SyncVariable(name="ChaosGenerated")
    private int chaosGenerated;
    private int chaosBuffer;
    private int updateTimer = 0;
    final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return SuperchargerTileEntity.this.progress;
                }
                case 1: {
                    return SuperchargerTileEntity.this.processTime;
                }
                case 2: {
                    return SuperchargerTileEntity.this.chaosGenerated;
                }
                case 3: {
                    return SuperchargerTileEntity.this.structureLevel;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    SuperchargerTileEntity.this.progress = value;
                    break;
                }
                case 1: {
                    SuperchargerTileEntity.this.processTime = value;
                    break;
                }
                case 2: {
                    SuperchargerTileEntity.this.chaosGenerated = value;
                    break;
                }
                case 3: {
                    SuperchargerTileEntity.this.structureLevel = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };

    public SuperchargerTileEntity() {
        super(GemsTileEntities.SUPERCHARGER.type(), 3);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.updateTimer;
        if (this.updateTimer > UPDATE_FREQUENCY) {
            if (this.checkStructureLevel()) {
                SilentGems.LOGGER.info("Supercharger at {}: structure level updated to {}", (Object)this.field_174879_c, (Object)this.structureLevel);
            }
            this.updateTimer = 0;
            this.sendUpdate();
        }
        ItemStack input = this.getInputItem();
        ItemStack catalyst = this.getCatalystItem();
        int superchargedLevel = EnchantmentHelper.func_77506_a((Enchantment)GemsEnchantments.supercharged, (ItemStack)input);
        if (!input.func_190926_b() && !catalyst.func_190926_b() && superchargedLevel < 1) {
            this.handleCharging(input, catalyst);
        } else if (this.progress > 0) {
            this.progress = 0;
            this.chaosGenerated = 0;
            this.processTime = 100;
            this.sendUpdate();
        }
    }

    private void handleCharging(ItemStack input, ItemStack catalyst) {
        int chargeTier = SuperchargerTileEntity.getChargingAgentTier(catalyst);
        if (chargeTier > 0 && chargeTier <= this.structureLevel) {
            int partTier = SGearProxy.getPartTier(input);
            this.chaosGenerated = SuperchargerTileEntity.getEmissionRate(partTier, chargeTier);
            this.chaosBuffer += this.chaosGenerated;
            if (this.wouldFitInOutputSlot(input, chargeTier)) {
                ++this.progress;
                this.processTime = SuperchargerTileEntity.getProcessTime(partTier, chargeTier);
                if (this.progress >= this.processTime) {
                    if (this.func_70301_a(2).func_190926_b()) {
                        ItemStack output = input.func_77946_l();
                        output.func_190920_e(1);
                        output.func_77966_a((Enchantment)GemsEnchantments.supercharged, chargeTier);
                        this.func_70299_a(2, output);
                    } else {
                        this.func_70301_a(2).func_190917_f(1);
                    }
                    this.progress = 0;
                    this.func_70298_a(0, 1);
                    this.func_70298_a(1, 1);
                }
            }
            this.sendUpdate();
        }
        if (this.chaosBuffer > 0 && this.field_145850_b.func_82737_E() % 20L == 0L) {
            Chaos.generate((ICapabilityProvider)this.field_145850_b, this.chaosBuffer, this.field_174879_c);
            this.chaosBuffer = 0;
        }
    }

    private void sendUpdate() {
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private ItemStack getInputItem() {
        ItemStack stack = this.func_70301_a(0);
        return SGearProxy.isMainPart(stack) ? stack : ItemStack.field_190927_a;
    }

    private ItemStack getCatalystItem() {
        ItemStack stack = this.func_70301_a(1);
        return SuperchargerTileEntity.getChargingAgentTier(stack) > 0 ? stack : ItemStack.field_190927_a;
    }

    private boolean checkStructureLevel() {
        int oldValue = this.structureLevel;
        this.structureLevel = MathUtils.min((int)this.getPillarLevel(this.field_174879_c.func_177967_a(Direction.NORTH, 3).func_177967_a(Direction.WEST, 3)), (int)this.getPillarLevel(this.field_174879_c.func_177967_a(Direction.NORTH, 3).func_177967_a(Direction.EAST, 3)), (int)this.getPillarLevel(this.field_174879_c.func_177967_a(Direction.SOUTH, 3).func_177967_a(Direction.WEST, 3)), (int)this.getPillarLevel(this.field_174879_c.func_177967_a(Direction.SOUTH, 3).func_177967_a(Direction.EAST, 3)));
        return this.structureLevel != oldValue;
    }

    private int getPillarLevel(BlockPos pos) {
        BlockState state1 = this.field_145850_b.func_180495_p(pos);
        BlockState state2 = this.field_145850_b.func_180495_p(pos.func_177984_a());
        if (state1.func_203425_a(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL1) && state2.func_203425_a(GemsTags.Blocks.SUPERCHARGER_PILLAR_CAP)) {
            return 1;
        }
        BlockState state3 = this.field_145850_b.func_180495_p(pos.func_177981_b(2));
        if (state1.func_203425_a(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL2) && state2.func_203425_a(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL1) && state3.func_203425_a(GemsTags.Blocks.SUPERCHARGER_PILLAR_CAP)) {
            return 2;
        }
        BlockState state4 = this.field_145850_b.func_180495_p(pos.func_177981_b(3));
        BlockState state5 = this.field_145850_b.func_180495_p(pos.func_177981_b(4));
        if (state1.func_203425_a(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL3) && state2.func_203425_a(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL3) && state3.func_203425_a(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL2) && state4.func_203425_a(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL1) && state5.func_203425_a(GemsTags.Blocks.SUPERCHARGER_PILLAR_CAP)) {
            return 3;
        }
        return 0;
    }

    private static int getChargingAgentTier(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item.func_206844_a(GemsTags.Items.CHARGING_AGENT_TIER3)) {
            return 3;
        }
        if (item.func_206844_a(GemsTags.Items.CHARGING_AGENT_TIER2)) {
            return 2;
        }
        if (item.func_206844_a(GemsTags.Items.CHARGING_AGENT_TIER1)) {
            return 1;
        }
        return 0;
    }

    private boolean wouldFitInOutputSlot(ItemStack input, int chargeTier) {
        ItemStack output = this.func_70301_a(2);
        if (output.func_190926_b()) {
            return true;
        }
        return output.func_190916_E() < output.func_77976_d() && input.func_77969_a(output) && EnchantmentHelper.func_77506_a((Enchantment)GemsEnchantments.supercharged, (ItemStack)output) == chargeTier && SGearProxy.getGradeString(input).equalsIgnoreCase(SGearProxy.getGradeString(output));
    }

    public static int getEmissionRate(int partTier, int chargeTier) {
        if (chargeTier <= 0 || partTier < 0) {
            return 0;
        }
        return (int)((double)(4 * chargeTier) * Math.pow(5.0, partTier));
    }

    public static int getProcessTime(int partTier, int chargeTier) {
        if (chargeTier <= 0 || partTier < 0) {
            return 0;
        }
        return (int)(4.0 + (double)(3 * chargeTier) * Math.pow(2.0, partTier + 1));
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return SGearProxy.isMainPart(stack);
        }
        if (index == 1) {
            return stack.func_77973_b().func_206844_a(GemsTags.Items.CHARGING_AGENTS);
        }
        return false;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.silentgems.supercharger", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new SuperchargerContainer(id, playerInventory, this);
    }

    public int[] func_180463_a(Direction side) {
        switch (side) {
            case UP: {
                return new int[]{0, 1};
            }
            case DOWN: {
                return new int[]{0, 1, 2};
            }
        }
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 2;
    }

    public void func_145839_a(CompoundNBT tags) {
        super.func_145839_a(tags);
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundNBT)tags);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.WRITE);
        return tags;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        return tags;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundNBT)packet.func_148857_g());
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getStructureLevel() {
        return this.structureLevel;
    }

    public int getChaosGenerated() {
        return this.chaosGenerated;
    }
}

