/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.teleporter;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.teleporter.GemTeleporterTileEntity;
import net.silentchaos512.gems.item.ReturnHomeCharmItem;
import net.silentchaos512.gems.item.TeleporterLinkerItem;
import net.silentchaos512.gems.lib.Gems;

public class GemTeleporterBlock
extends Block
implements ITileEntityProvider {
    @Nullable
    final Gems gem;
    private final boolean isAnchor;

    public GemTeleporterBlock(@Nullable Gems gem, boolean isAnchor) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(15.0f, 2000.0f).func_200947_a(SoundType.field_185852_e));
        this.gem = gem;
        this.isAnchor = isAnchor;
    }

    @Nullable
    public Gems getGem() {
        return this.gem;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new GemTeleporterTileEntity(this.isAnchor);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.gem != null) {
            tooltip.add(this.gem.getSet().getDisplayName());
        }
    }

    public ITextComponent func_200291_n() {
        if (this.gem == null) {
            return super.func_200291_n();
        }
        return new TranslationTextComponent("block.silentgems.teleporter", new Object[]{this.gem.getDisplayName()});
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean holdingReturnHome;
        ItemStack heldItem = player.func_184586_b(hand);
        boolean holdingLinker = !heldItem.func_190926_b() && heldItem.func_77973_b() == TeleporterLinkerItem.INSTANCE.get();
        boolean bl = holdingReturnHome = !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ReturnHomeCharmItem;
        if (world.field_72995_K) {
            return holdingLinker || holdingReturnHome || !this.isAnchor;
        }
        GemTeleporterTileEntity tile = (GemTeleporterTileEntity)world.func_175625_s(pos);
        if (tile == null) {
            SilentGems.LOGGER.warn("Teleporter tile at {} not found!", (Object)pos);
            return false;
        }
        return tile.interact(player, heldItem, hand);
    }
}

